/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.displayer.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.displayer.HTMLDisplayer;
import org.xwiki.displayer.HTMLDisplayerException;
import org.xwiki.displayer.HTMLDisplayerManager;

@Component
@Singleton
public class DefaultHTMLDisplayerManager
implements HTMLDisplayerManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public <T> HTMLDisplayer<T> getHTMLDisplayer(Type targetType) throws HTMLDisplayerException {
        return this.getHTMLDisplayer(targetType, null);
    }

    @Override
    public <T> HTMLDisplayer<T> getHTMLDisplayer(Type targetType, String roleHint) throws HTMLDisplayerException {
        try {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            Type type = targetType;
            DefaultParameterizedType displayerType = new DefaultParameterizedType(null, HTMLDisplayer.class, new Type[]{type});
            while (!componentManager.hasComponent((Type)displayerType, roleHint) && type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                displayerType = new DefaultParameterizedType(null, HTMLDisplayer.class, new Type[]{type});
            }
            if (!componentManager.hasComponent((Type)displayerType, roleHint)) {
                displayerType = new DefaultParameterizedType(null, HTMLDisplayer.class, new Type[]{Object.class});
            }
            HTMLDisplayer component = componentManager.hasComponent((Type)displayerType, roleHint) ? (HTMLDisplayer)componentManager.getInstance((Type)displayerType, roleHint) : (HTMLDisplayer)componentManager.getInstance((Type)displayerType);
            return component;
        }
        catch (ComponentLookupException e) {
            throw new HTMLDisplayerException("Failed to initialized the HTML displayer for target type [" + targetType + "] and role [" + String.valueOf(roleHint) + "]", e);
        }
    }

    @Override
    public <T> String display(Type targetType, T value) throws HTMLDisplayerException {
        Type type = this.getType(targetType, value);
        return this.getHTMLDisplayer(type).display(type, value);
    }

    @Override
    public <T> String display(Type targetType, T value, Map<String, String> parameters) throws HTMLDisplayerException {
        Type type = this.getType(targetType, value);
        return this.getHTMLDisplayer(type).display(type, value, parameters);
    }

    @Override
    public <T> String display(Type targetType, T value, Map<String, String> parameters, String mode) throws HTMLDisplayerException {
        Type type = this.getType(targetType, value);
        return this.getHTMLDisplayer(type).display(type, value, parameters, mode);
    }

    private <T> Type getType(Type targetType, T value) {
        if (targetType == null && value != null) {
            return value.getClass();
        }
        return targetType;
    }
}

