/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionPattern;

public abstract class AbstractExtensionPattern
implements ExtensionPattern {
    protected final Pattern idPattern;

    public AbstractExtensionPattern(ExtensionPattern pattern) {
        this(pattern.getIdPattern());
    }

    public AbstractExtensionPattern(Pattern idPattern) {
        this.idPattern = idPattern;
    }

    public AbstractExtensionPattern(String id) {
        this(Pattern.compile(id, 16));
    }

    @Override
    public Pattern getIdPattern() {
        return this.idPattern;
    }

    public boolean matches(String extensionId) {
        return this.getIdPattern() == null || this.getIdPattern().matcher(extensionId).matches();
    }

    @Override
    public boolean matches(ExtensionId extensionId) {
        return this.matches(extensionId.getId());
    }

    @Override
    public boolean matches(ExtensionDependency dependency) {
        return this.matches(dependency.getId());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getIdPattern());
        return str.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getIdPattern() != null ? this.getIdPattern().pattern() : null);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtensionPattern) {
            ExtensionPattern otherPattern = (ExtensionPattern)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)(this.getIdPattern() != null ? this.getIdPattern().pattern() : null), otherPattern.getIdPattern() != null ? otherPattern.getIdPattern().pattern() : null);
            equals = builder.isEquals();
        } else {
            equals = false;
        }
        return equals;
    }
}

