/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.lang.reflect.Field;
import javax.inject.Inject;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.extension.test.MockitoRepositoryUtils;
import org.xwiki.test.mockito.MockitoComponentManager;

public class MockitoRepositoryUtilsExtension
implements BeforeEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance().get();
        MockitoRepositoryUtils utils = new MockitoRepositoryUtils(this.loadComponentManager(context));
        utils.setup();
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            if (field.getType() != MockitoRepositoryUtils.class || !field.isAnnotationPresent(Inject.class)) continue;
            ReflectionUtils.setFieldValue(testInstance, (String)field.getName(), (Object)utils);
        }
    }

    protected MockitoComponentManager loadComponentManager(ExtensionContext context) {
        ExtensionContext.Store store = MockitoRepositoryUtilsExtension.getGlobalRootStore(context);
        Class testClass = context.getRequiredTestClass();
        return (MockitoComponentManager)store.get((Object)testClass, MockitoComponentManager.class);
    }

    private static ExtensionContext.Store getGlobalRootStore(ExtensionContext context) {
        return context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
    }
}

