/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.environment.Environment;
import org.xwiki.extension.test.DefaultRepositorySerializer;
import org.xwiki.extension.test.ExtensionPackager;
import org.xwiki.extension.test.MavenRepositorySerializer;
import org.xwiki.extension.test.RepositorySerializer;

public class RepositoryUtils {
    protected static final String MAVENREPOSITORY_ID = "test-maven";
    protected static final String MAVEN2REPOSITORY_ID = "test-maven2";
    protected static final String MAVENUNKNWONREPOSITORY_ID = "test-mavenunknown";
    protected File permanentDirectory;
    protected File temporaryDirectory;
    protected File extensionDirectory;
    protected File localRepositoryRoot;
    protected File mavenRepositoryRoot;
    protected File maven2RepositoryRoot;
    protected File mavenUnknownRepositoryRoot;
    protected File remoteRepositoryRoot;
    protected ExtensionPackager extensionPackager;

    public RepositoryUtils() {
        this.initializeDirectories();
    }

    protected void initializeDirectories(Environment environment) {
        this.temporaryDirectory = environment.getTemporaryDirectory();
        this.permanentDirectory = environment.getPermanentDirectory();
        this.initializeDirectories();
    }

    protected void initializeDirectories() {
        File testDirectory = new File("target/test-" + new Date().getTime()).getAbsoluteFile();
        if (this.temporaryDirectory == null) {
            this.temporaryDirectory = new File(testDirectory, "temporary-dir");
            this.permanentDirectory = new File(testDirectory, "permanent-dir");
        }
        this.extensionDirectory = new File(this.permanentDirectory, "extension/");
        this.localRepositoryRoot = new File(this.extensionDirectory, "repository/");
        this.mavenRepositoryRoot = new File(testDirectory, "maven/");
        this.maven2RepositoryRoot = new File(testDirectory, "maven2/");
        this.mavenUnknownRepositoryRoot = new File(testDirectory, "mavenunknown/");
        this.remoteRepositoryRoot = new File(testDirectory, "remote/");
        HashMap<String, RepositorySerializer> repositories = new HashMap<String, RepositorySerializer>();
        repositories.put(null, new DefaultRepositorySerializer(this.getRemoteRepository()));
        repositories.put("remote", (RepositorySerializer)repositories.get(null));
        repositories.put("local", new DefaultRepositorySerializer(this.getLocalRepository()));
        repositories.put("maven", new MavenRepositorySerializer(this.getMavenRepository()));
        repositories.put("maven2", new MavenRepositorySerializer(this.getMaven2Repository()));
        this.extensionPackager = new ExtensionPackager(this.permanentDirectory, repositories);
        System.setProperty("extension.repository.local", this.getLocalRepository().getAbsolutePath());
        System.setProperty("extension.repository.maven", this.getMavenRepository().getAbsolutePath());
        System.setProperty("extension.repository.maven2", this.getMaven2Repository().getAbsolutePath());
        System.setProperty("extension.repository.remote", this.getRemoteRepository().getAbsolutePath());
        System.setProperty("extension.repository.mavenunknown", this.getRemoteRepository().getAbsolutePath());
    }

    public File getPermanentDirectory() {
        return this.permanentDirectory;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getExtensionDirectory() {
        return this.extensionDirectory;
    }

    public File getLocalRepository() {
        return this.localRepositoryRoot;
    }

    public File getRemoteRepository() {
        return this.remoteRepositoryRoot;
    }

    public File getMavenRepository() {
        return this.mavenRepositoryRoot;
    }

    public File getMaven2Repository() {
        return this.maven2RepositoryRoot;
    }

    public File getMavenUnknownRepository() {
        return this.mavenUnknownRepositoryRoot;
    }

    public String getMavenRepositoryId() {
        return MAVENREPOSITORY_ID;
    }

    public String getMaven2RepositoryId() {
        return MAVEN2REPOSITORY_ID;
    }

    public String getMavenUnknown() {
        return MAVEN2REPOSITORY_ID;
    }

    public ExtensionPackager getExtensionPackager() {
        return this.extensionPackager;
    }

    public void setup() throws Exception {
        this.copyResourceFolder(this.getLocalRepository(), "repository.local");
        this.copyResourceFolder(this.getMavenRepository(), "repository.maven");
        this.copyResourceFolder(this.getMaven2Repository(), "repository.maven2");
        this.copyResourceFolder(this.getMavenUnknownRepository(), "repository.mavenunknown");
        this.extensionPackager.generateExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyResourceFolder(File targetFolder, String resourcePackage) throws IOException {
        int nb = 0;
        Collection urls = ClasspathHelper.forPackage((String)resourcePackage, (ClassLoader[])new ClassLoader[0]);
        if (!urls.isEmpty()) {
            String prefix = resourcePackage;
            if (!prefix.endsWith(".")) {
                prefix = prefix + '.';
            }
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(urls).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)prefix))));
            for (String resource : reflections.getResources(Pattern.compile(".*"))) {
                targetFolder.mkdirs();
                File targetFile = new File(targetFolder, resource.substring(prefix.length()));
                try (InputStream resourceStream = this.getClass().getResourceAsStream("/" + resource);){
                    FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
                    ++nb;
                }
            }
        }
        return nb;
    }
}

