/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.core.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.extension.repository.internal.core.MavenCoreExtension;
import org.xwiki.extension.repository.internal.core.MavenCoreExtensionDependency;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultCoreExtensionScanner
implements CoreExtensionScanner {
    private static final String MAVENPACKAGE = "META-INF.maven";
    private static final String UNKNOWN = "unknown";
    private static final String SNAPSHOTSUFFIX = "-SNAPSHOT";
    private static final Pattern PARSER_ID = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?");
    private static final String MF_EXTENSION_ID = "XWiki-Extension-Id";
    @Inject
    private Logger logger;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private ConverterManager converter;
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private Environment environment;

    private Dependency toDependency(String id, String version, String type) throws ResolveException {
        Matcher matcher = PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new ResolveException("Bad id " + id + ", expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(matcher.group(1));
        dependency.setArtifactId(matcher.group(2));
        if (matcher.group(4) != null) {
            dependency.setClassifier(StringUtils.defaultString((String)matcher.group(4), (String)""));
        }
        if (version != null) {
            dependency.setVersion(version);
        }
        if (type != null) {
            dependency.setType(type);
        }
        return dependency;
    }

    private String getArtifactId(DefaultCoreExtension extension) throws ResolveException {
        String artifactId;
        Model model = (Model)extension.getProperty("maven.Model");
        if (model != null) {
            artifactId = model.getArtifactId();
        } else {
            Matcher matcher = PARSER_ID.matcher(extension.getId().getId());
            if (!matcher.matches()) {
                throw new ResolveException("Bad id " + extension.getId().getId() + ", expected format is <groupId>:<artifactId>[:<classifier>]");
            }
            artifactId = matcher.group(2);
        }
        return artifactId;
    }

    private String toExtensionId(String groupId, String artifactId, String classifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(groupId);
        builder.append(':');
        builder.append(artifactId);
        if (StringUtils.isNotEmpty((CharSequence)classifier)) {
            builder.append(':');
            builder.append(classifier);
        }
        return builder.toString();
    }

    private URL getExtensionURL(URL descriptorUrl) throws MalformedURLException {
        String extensionURLStr = descriptorUrl.toString();
        if ((extensionURLStr = extensionURLStr.substring(0, descriptorUrl.toString().indexOf(MAVENPACKAGE.replace('.', '/')))).startsWith("jar:")) {
            int start = "jar:".length();
            int end = extensionURLStr.length();
            if (extensionURLStr.endsWith("!/")) {
                end -= "!/".length();
            }
            extensionURLStr = extensionURLStr.substring(start, end);
        }
        return new URL(extensionURLStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension parseMavenPom(URL descriptorUrl, DefaultCoreExtensionRepository repository) throws IOException, XmlPullParserException {
        MavenCoreExtension coreExtension = null;
        InputStream descriptorStream = descriptorUrl.openStream();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model mavenModel = reader.read(descriptorStream);
            String version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            String groupId = this.resolveGroupId(mavenModel.getGroupId(), mavenModel, false);
            URL extensionURL = this.getExtensionURL(descriptorUrl);
            coreExtension = new MavenCoreExtension(repository, extensionURL, new ExtensionId(groupId + ':' + mavenModel.getArtifactId(), version), this.packagingToType(mavenModel.getPackaging()), mavenModel);
            coreExtension.setName(mavenModel.getName());
            coreExtension.setSummary(mavenModel.getDescription());
            for (Developer developer : mavenModel.getDevelopers()) {
                URL authorURL = null;
                if (developer.getUrl() != null) {
                    try {
                        authorURL = new URL(developer.getUrl());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                coreExtension.addAuthor(new DefaultExtensionAuthor(developer.getId(), authorURL));
            }
            coreExtension.setWebsite(mavenModel.getUrl());
            for (License license : mavenModel.getLicenses()) {
                coreExtension.addLicense(this.getExtensionLicense(license));
            }
            String featuresString = mavenModel.getProperties().getProperty("xwiki.extension.features");
            if (StringUtils.isNotBlank((CharSequence)featuresString)) {
                coreExtension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
            }
            coreExtension.putProperty("maven.groupId", groupId);
            coreExtension.putProperty("maven.artifactId", mavenModel.getArtifactId());
            for (Dependency mavenDependency : mavenModel.getDependencies()) {
                if (mavenDependency.isOptional() || mavenDependency.getScope() != null && !mavenDependency.getScope().equals("compile") && !mavenDependency.getScope().equals("runtime")) continue;
                String dependencyGroupId = this.resolveGroupId(mavenDependency.getGroupId(), mavenModel, true);
                String dependencyArtifactId = mavenDependency.getArtifactId();
                String dependencyClassifier = mavenDependency.getClassifier();
                String dependencyVersion = this.resolveVersion(mavenDependency.getVersion(), mavenModel, true);
                MavenCoreExtensionDependency extensionDependency = new MavenCoreExtensionDependency(this.toExtensionId(dependencyGroupId, dependencyArtifactId, dependencyClassifier), (VersionConstraint)new DefaultVersionConstraint(dependencyVersion), mavenDependency);
                coreExtension.addDependency(extensionDependency);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
        return coreExtension;
    }

    @Override
    public void updateExtensions(Collection<DefaultCoreExtension> extensions) {
        for (DefaultCoreExtension extension : extensions) {
            try {
                Extension remoteExtension = this.repositoryManager.resolve(extension.getId());
                extension.set(remoteExtension);
            }
            catch (ResolveException e) {
                this.logger.debug("Can't find remote extension with id [{}]", (Object)extension.getId(), (Object)e);
            }
        }
    }

    @Override
    public Map<String, DefaultCoreExtension> loadExtensions(DefaultCoreExtensionRepository repository) {
        HashMap<String, DefaultCoreExtension> extensions = new HashMap<String, DefaultCoreExtension>();
        this.loadExtensionsFromClassloaders(extensions, repository);
        return extensions;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DefaultCoreExtension loadEnvironmentExtensions(DefaultCoreExtensionRepository repository) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadExtensionsFromClassloaders(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        Set mavenURLs = ClasspathHelper.forPackage((String)MAVENPACKAGE, (ClassLoader[])new ClassLoader[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{new ResourcesScanner()});
        configurationBuilder.setUrls((Collection)mavenURLs);
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)MAVENPACKAGE)));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set descriptors = reflections.getResources(Predicates.equalTo((Object)"pom.xml"));
        for (String descriptor : descriptors) {
            URL descriptorUrl = this.getClass().getClassLoader().getResource(descriptor);
            try {
                DefaultCoreExtension coreExtension = this.parseMavenPom(descriptorUrl, repository);
                extensions.put(coreExtension.getId().getId(), coreExtension);
            }
            catch (Exception e) {
                this.logger.warn("Failed to pase extension descriptor [{}]", (Object)descriptorUrl, (Object)e);
            }
        }
        this.guess(extensions, repository);
    }

    private void guess(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        HashSet<ExtensionDependency> dependencies = new HashSet<ExtensionDependency>();
        HashSet<String> validaedFiles = new HashSet<String>();
        for (DefaultCoreExtension coreExtension : extensions.values()) {
            validaedFiles.add(coreExtension.getURL().toString());
            for (ExtensionDependency dependency : coreExtension.getDependencies()) {
                if (extensions.containsKey(dependency.getId())) continue;
                dependencies.add(dependency);
            }
        }
        HashMap<String, Object[]> fileNames = new HashMap<String, Object[]>();
        HashMap<String, Object[]> guessedArtefacts = new HashMap<String, Object[]>();
        Set urls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[0]);
        for (URL url : urls) {
            if (validaedFiles.contains(url.toString())) continue;
            try {
                int index;
                String path = url.toURI().getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                String type = null;
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    type = filename.substring(extIndex + 1);
                    filename = filename.substring(0, extIndex);
                }
                if ((index = !filename.endsWith(SNAPSHOTSUFFIX) ? filename.lastIndexOf(45) : filename.lastIndexOf(45, filename.length() - SNAPSHOTSUFFIX.length())) == -1) continue;
                fileNames.put(filename, new Object[]{url});
                String artefactname = filename.substring(0, index);
                String version = filename.substring(index + 1);
                guessedArtefacts.put(artefactname, new Object[]{version, url, type});
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse resource name [{}]", (Object)url, (Object)e);
            }
        }
        try {
            for (DefaultCoreExtension coreExtension : extensions.values()) {
                String artifactId = this.getArtifactId(coreExtension);
                Object[] artefact = (Object[])guessedArtefacts.get(artifactId);
                if (artefact == null) continue;
                if (coreExtension.getId().getVersion().getValue().charAt(0) == '$') {
                    coreExtension.setId(new ExtensionId(coreExtension.getId().getId(), (String)artefact[0]));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension.getType().charAt(0) != '$') continue;
                coreExtension.setType((String)artefact[2]);
                coreExtension.setGuessed(true);
            }
            for (ExtensionDependency extensionDependency : dependencies) {
                String dependencyId;
                DefaultCoreExtension coreExtension;
                Dependency dependency = (Dependency)extensionDependency.getProperty("maven.Dependency");
                if (dependency == null) {
                    dependency = this.toDependency(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue(), null);
                }
                if ((coreExtension = extensions.get(dependencyId = dependency.getGroupId() + ':' + dependency.getArtifactId())) != null) continue;
                String dependencyFileName = dependency.getArtifactId() + '-' + dependency.getVersion();
                if (dependency.getClassifier() != null) {
                    dependencyFileName = dependencyFileName + '-' + dependency.getClassifier();
                    dependencyId = dependencyId + ':' + dependency.getClassifier();
                }
                Object[] filenameArtifact = (Object[])fileNames.get(dependencyFileName);
                Object[] guessedArtefact = (Object[])guessedArtefacts.get(dependency.getArtifactId());
                if (filenameArtifact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)filenameArtifact[0], new ExtensionId(dependencyId, dependency.getVersion()), this.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                } else if (guessedArtefact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)guessedArtefact[1], new ExtensionId(dependencyId, (String)guessedArtefact[0]), this.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension == null) continue;
                extensions.put(dependencyId, coreExtension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to guess extra information about some extensions", (Throwable)e);
        }
    }

    private String resolveVersion(String modelVersion, Model mavenModel, boolean dependency) {
        String version = modelVersion;
        if (version == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                version = parent.getVersion();
            }
        } else if (version.startsWith("$")) {
            String propertyName = version.substring(2, version.length() - 1);
            if (propertyName.equals("project.version") || propertyName.equals("pom.version") || propertyName.equals("version")) {
                version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            } else {
                String value = mavenModel.getProperties().getProperty(propertyName);
                if (value != null) {
                    version = value;
                }
            }
        }
        if (version == null) {
            version = UNKNOWN;
        }
        return version;
    }

    private String resolveGroupId(String modelGroupId, Model mavenModel, boolean dependency) {
        String groupId = modelGroupId;
        if (groupId == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                groupId = parent.getGroupId();
            }
        } else if (groupId.startsWith("$")) {
            String propertyName = groupId.substring(2, groupId.length() - 1);
            String value = mavenModel.getProperties().getProperty(propertyName);
            if (value != null) {
                groupId = value;
            }
        }
        if (groupId == null) {
            groupId = UNKNOWN;
        }
        return groupId;
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(license.getName());
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(license.getName(), null);
    }

    private String packagingToType(String packaging) {
        if (packaging.equals("bundle")) {
            return "jar";
        }
        return packaging;
    }
}

