/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.internal.ExtensionManagerConfigurationException;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryId;

@Component
@Singleton
public class DefaultExtensionManagerConfiguration
implements ExtensionManagerConfiguration {
    private static final Pattern REPOSITORYIDPATTERN = Pattern.compile("([^:]+):([^:]+):(.+)");
    private static final String DEFAULT_USERAGENT = "XWikiExtensionManager";
    private static final String CK_PEFIX = "extension.";
    private static final String CK_REPOSITORIES_PEFIX = "extension.repositories.";
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private Provider<ConfigurationSource> configuration;
    private File localRepository;

    public File getHome() {
        return new File(this.environment.getPermanentDirectory(), "extension/");
    }

    @Override
    public File getLocalRepository() {
        if (this.localRepository == null) {
            String localRepositoryPath = (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.localRepository");
            this.localRepository = localRepositoryPath == null ? new File(this.getHome(), "repository/") : new File(localRepositoryPath);
        }
        return this.localRepository;
    }

    @Override
    public Collection<ExtensionRepositoryDescriptor> getExtensionRepositoryDescriptors() {
        Collection repositories;
        List repositoryStrings = (List)((ConfigurationSource)this.configuration.get()).getProperty("extension.repositories", Collections.emptyList());
        if (repositoryStrings.isEmpty()) {
            repositories = null;
        } else {
            LinkedHashMap<String, DefaultExtensionRepositoryDescriptor> repositoriesMap = new LinkedHashMap<String, DefaultExtensionRepositoryDescriptor>();
            for (String repositoryString : repositoryStrings) {
                if (StringUtils.isNotBlank((CharSequence)repositoryString)) {
                    try {
                        DefaultExtensionRepositoryDescriptor extensionRepositoryId = this.parseRepository(repositoryString);
                        if (repositoriesMap.containsKey(extensionRepositoryId.getId())) {
                            this.logger.warn("Duplicated repository id in [{}] first found in [{}]. The last one will be used.", (Object)extensionRepositoryId, repositoriesMap.get(extensionRepositoryId.getId()));
                        }
                        repositoriesMap.put(extensionRepositoryId.getId(), extensionRepositoryId);
                    }
                    catch (Exception e) {
                        this.logger.warn("Ignoring invalid repository configuration [{}]. Root cause [{}]", (Object)repositoryString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    continue;
                }
                this.logger.debug("Empty repository id found in the configuration");
            }
            repositories = repositoriesMap.values();
            for (ExtensionRepositoryDescriptor descriptor : repositories) {
                this.setRepositoryProperties((DefaultExtensionRepositoryDescriptor)descriptor);
            }
        }
        return repositories;
    }

    private void setRepositoryProperties(DefaultExtensionRepositoryDescriptor descriptor) {
        String id = descriptor.getId();
        String prefix = CK_REPOSITORIES_PEFIX + id + '.';
        ConfigurationSource configurationSource = (ConfigurationSource)this.configuration.get();
        for (String key : configurationSource.getKeys()) {
            if (!key.startsWith(prefix)) continue;
            descriptor.putProperty(key.substring(prefix.length()), (String)configurationSource.getProperty(key, String.class));
        }
    }

    @Override
    public Collection<ExtensionRepositoryId> getRepositories() {
        ArrayList<ExtensionRepositoryId> repositories = new ArrayList<ExtensionRepositoryId>();
        for (ExtensionRepositoryDescriptor descriptor : this.getExtensionRepositoryDescriptors()) {
            repositories.add(new ExtensionRepositoryId(descriptor));
        }
        return repositories;
    }

    private DefaultExtensionRepositoryDescriptor parseRepository(String repositoryString) throws URISyntaxException, ExtensionManagerConfigurationException {
        Matcher matcher = REPOSITORYIDPATTERN.matcher(repositoryString);
        if (matcher.matches()) {
            return new DefaultExtensionRepositoryDescriptor(matcher.group(1), matcher.group(2), new URI(matcher.group(3)));
        }
        throw new ExtensionManagerConfigurationException(String.format("Invalid repository configuration format for [%s]. Should have been matching [%s].", repositoryString, REPOSITORYIDPATTERN.toString()));
    }

    @Override
    public String getUserAgent() {
        return (String)((ConfigurationSource)this.configuration.get()).getProperty("extension.userAgent", (Object)DEFAULT_USERAGENT);
    }
}

