/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.version.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.version.InvalidVersionRangeException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.VersionRangeCollection;
import org.xwiki.extension.version.internal.DefaultVersionRange;
import org.xwiki.extension.version.internal.VersionUtils;

public class DefaultVersionRangeCollection
implements VersionRangeCollection {
    private static final long serialVersionUID = 1L;
    private static final char RANGE_SEPARATOR = ',';
    private List<VersionRange> ranges = new ArrayList<VersionRange>();
    private String value;

    public DefaultVersionRangeCollection(String rawRanges) throws InvalidVersionRangeException {
        this.setRanges(rawRanges);
    }

    public DefaultVersionRangeCollection(Collection<? extends VersionRange> ranges) {
        for (VersionRange versionRange : ranges) {
            this.ranges.add(versionRange);
        }
    }

    private void setRanges(String rawRanges) throws InvalidVersionRangeException {
        this.value = rawRanges;
        if (StringUtils.isEmpty((CharSequence)rawRanges)) {
            throw new InvalidVersionRangeException("Range can't be empty");
        }
        this.parseRanges(this.value);
    }

    private void parseRanges(String rawRanges) throws InvalidVersionRangeException {
        String currentRanges = rawRanges;
        while (VersionUtils.startsWith(currentRanges, '[') || VersionUtils.startsWith(currentRanges, '(')) {
            int index2;
            int index1 = currentRanges.indexOf(41);
            int index = index2 = currentRanges.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionRangeException("Unbounded version range [" + rawRanges + "]");
            }
            if (!VersionUtils.startsWith(currentRanges = this.parseRange(currentRanges, index, rawRanges), ',')) continue;
            currentRanges = currentRanges.substring(1).trim();
        }
        if (!currentRanges.isEmpty()) {
            throw new InvalidVersionRangeException(String.format("Invalid version range [%s], expected [ or ( but got [%s]", rawRanges, currentRanges));
        }
    }

    private String parseRange(String currentRanges, int index, String rawRanges) throws InvalidVersionRangeException {
        String range = currentRanges.substring(0, index + 1);
        try {
            this.ranges.add(new DefaultVersionRange(range));
        }
        catch (InvalidVersionRangeException e) {
            throw new InvalidVersionRangeException(String.format("Failed to parse version range [%s] in constraint [%s]", range, rawRanges), e);
        }
        return currentRanges.substring(index + 1).trim();
    }

    @Override
    public Collection<VersionRange> getRanges() {
        return this.ranges;
    }

    @Override
    public boolean containsVersion(Version version) {
        for (VersionRange range : this.getRanges()) {
            if (!range.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            StringBuilder buffer = new StringBuilder();
            for (VersionRange range : this.ranges) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(range);
            }
            this.value = buffer.toString();
        }
        return this.value;
    }

    @Override
    public boolean isCompatible(VersionRange otherRange) {
        if (this.equals(otherRange)) {
            return true;
        }
        for (VersionRange versionRange : this.ranges) {
            boolean compatible = otherRange instanceof VersionRangeCollection ? ((VersionRangeCollection)otherRange).isCompatible(versionRange) : versionRange.isCompatible(otherRange);
            if (!compatible) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultVersionRangeCollection)) {
            return false;
        }
        DefaultVersionRangeCollection versionConstraint = (DefaultVersionRangeCollection)obj;
        return ((Object)this.ranges).equals(versionConstraint.getRanges());
    }

    public int hashCode() {
        return ((Object)this.ranges).hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidVersionRangeException {
        this.setRanges((String)in.readObject());
    }
}

