/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.util.Arrays;
import java.util.List;
import org.mockito.Mockito;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.FileExtensionRepository;
import org.xwiki.extension.test.RepositoryUtils;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.test.mockito.MockitoComponentManagerRule;

public class MockitoRepositoryUtils
extends RepositoryUtils {
    protected final MockitoComponentManagerRule componentManager;
    private FileExtensionRepository remoteRepository;
    private ComponentAnnotationLoader componentLoader;

    public MockitoRepositoryUtils(MockitoComponentManagerRule componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        MemoryConfigurationSource memoryConfigurationSource = this.componentManager.registerMemoryConfigurationSource();
        memoryConfigurationSource.setProperty("extension.repositories", Arrays.asList(""));
        Environment environment = (Environment)this.componentManager.registerMockComponent(Environment.class);
        Mockito.when((Object)environment.getPermanentDirectory()).thenReturn((Object)this.getPermanentDirectory());
        Mockito.when((Object)environment.getTemporaryDirectory()).thenReturn((Object)this.getTemporaryDirectory());
        Mockito.when((Object)environment.getResourceAsStream((String)Mockito.any(String.class))).thenReturn(null);
        DefaultComponentDescriptor dcd = new DefaultComponentDescriptor();
        dcd.setRoleType(Environment.class);
        this.componentManager.registerComponent((ComponentDescriptor)dcd, (Object)environment);
        this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
        ((ConfigurableDefaultCoreExtensionRepository)((Object)this.componentManager.getInstance(CoreExtensionRepository.class))).addExtensions("coreextension", (Version)new DefaultVersion("version"));
        ExtensionRepositoryManager repositoryManager = (ExtensionRepositoryManager)this.componentManager.getInstance(ExtensionRepositoryManager.class);
        if (this.copyResourceFolder(this.getRemoteRepository(), "repository.remote") > 0) {
            this.remoteRepository = new FileExtensionRepository(this.getRemoteRepository(), (ComponentManager)this.componentManager);
            repositoryManager.addRepository((ExtensionRepository)this.remoteRepository);
        }
        if (this.getMavenRepository().exists()) {
            repositoryManager.addRepository((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("test-maven", "maven", this.getMavenRepository().toURI()));
        }
        ((ExtensionInitializer)this.componentManager.getInstance(ExtensionInitializer.class)).initialize();
    }

    public MockitoComponentManagerRule getComponentManager() {
        return this.componentManager;
    }

    public ComponentAnnotationLoader getComponentLoader() {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        return this.componentLoader;
    }

    private void registerComponent(Class<?> componentClass) throws Exception {
        List descriptors = this.getComponentLoader().getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.componentManager.registerComponent(descriptor);
        }
    }
}

