/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;

@Component(roles={CoreExtensionCache.class})
@Singleton
public class CoreExtensionCache
implements Initializable {
    @Inject
    private Environment environment;
    @Inject
    private ExtensionSerializer serializer;
    @Inject
    private Logger logger;
    private File folder;

    public void initialize() throws InitializationException {
        File permanentDirectory = this.environment.getPermanentDirectory();
        if (permanentDirectory != null) {
            this.folder = new File(permanentDirectory, "cache/extension/core/");
        }
    }

    public void store(DefaultCoreExtension extension) throws Exception {
        if (this.folder == null) {
            return;
        }
        File file = this.getFile(extension.getDescriptorURL());
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.serializer.saveExtensionDescriptor(extension, stream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultCoreExtension getExtension(DefaultCoreExtensionRepository repository, URL descriptorURL) {
        if (this.folder == null) {
            return null;
        }
        File file = this.getFile(descriptorURL);
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            DefaultCoreExtension coreExtension = this.serializer.loadCoreExtensionDescriptor(repository, descriptorURL, stream);
            coreExtension.setCached(true);
            DefaultCoreExtension defaultCoreExtension = coreExtension;
            return defaultCoreExtension;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse cached core extension", (Throwable)e);
        }
        return null;
    }

    private File getFile(URL url) {
        String fileName = String.valueOf(url.toExternalForm().hashCode());
        return new File(this.folder, fileName + ".xed");
    }
}

