/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal;

import org.apache.maven.model.Model;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.version.Version;

public abstract class AbstractMavenExtension
extends AbstractExtension
implements MavenExtension {
    public static final String PKEY_MAVENPRFIX = "maven.";
    public static final String PKEY_MAVEN_MODEL = "maven.Model";
    public static final String PKEY_MAVEN_ARTIFACTID = "maven.artifactid";
    public static final String PKEY_MAVEN_GROUPID = "maven.groupid";
    public static final String PKEY_MAVEN_TYPE = "maven.type";
    public static final String PKEY_MAVEN_CLASSIFIER = "maven.classifier";

    public AbstractMavenExtension(ExtensionRepository repository, String groupId, String artifactId, String version, String type) {
        super(repository, new ExtensionId(groupId + ':' + artifactId, version), type);
        this.setMavenGroupId(groupId);
        this.setMavenArtifactId(artifactId);
    }

    public AbstractMavenExtension(ExtensionRepository repository, String groupId, String artifactId, Version version, String type) {
        this(repository, groupId, artifactId, null, version, type);
    }

    public AbstractMavenExtension(ExtensionRepository repository, String groupId, String artifactId, String classifier, Version version, String type) {
        super(repository, MavenUtils.toExtensionId(groupId, artifactId, classifier, version), type);
        this.setMavenGroupId(groupId);
        this.setMavenArtifactId(artifactId);
        if (classifier != null) {
            this.setMavenClassifier(classifier);
        }
    }

    public AbstractMavenExtension(ExtensionRepository repository, Extension extension) {
        super(repository, extension);
        if (extension instanceof MavenExtension) {
            MavenExtension mavenExtension = (MavenExtension)extension;
            this.setMavenArtifactId(mavenExtension.getMavenArtifactId());
            this.setMavenGroupId(mavenExtension.getMavenGroupId());
        }
    }

    @Override
    public String getMavenGroupId() {
        return (String)this.getProperty(PKEY_MAVEN_GROUPID);
    }

    public void setMavenGroupId(String groupId) {
        this.putProperty(PKEY_MAVEN_GROUPID, groupId);
    }

    @Override
    public String getMavenArtifactId() {
        return (String)this.getProperty(PKEY_MAVEN_ARTIFACTID);
    }

    public void setMavenArtifactId(String artifactId) {
        this.putProperty(PKEY_MAVEN_ARTIFACTID, artifactId);
    }

    public void setMavenClassifier(String classifier) {
        this.putProperty(PKEY_MAVEN_CLASSIFIER, classifier);
    }

    public Model getMavenModel() {
        return (Model)this.getProperty(PKEY_MAVEN_MODEL);
    }
}

