/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.configuration.AetherConfiguration;
import org.xwiki.extension.repository.aether.internal.plexus.PlexusComponentManager;

@Component
@Singleton
@Named(value="maven")
public class AetherExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private PlexusComponentManager plexusComponentManager;
    @Inject
    private AetherConfiguration aetherConfiguration;
    @Inject
    private ExtensionManagerConfiguration configuration;
    private LocalRepositoryManager localRepositoryManager;

    public void initialize() throws InitializationException {
        RepositorySystem repositorySystem;
        try {
            repositorySystem = (RepositorySystem)this.plexusComponentManager.getPlexus().lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to lookup RepositorySystem", (Throwable)e);
        }
        LocalRepository localRepo = new LocalRepository(this.aetherConfiguration.getLocalRepository());
        this.localRepositoryManager = repositorySystem.newLocalRepositoryManager(localRepo);
    }

    public RepositorySystemSession createRepositorySystemSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(this.localRepositoryManager);
        session.setIgnoreMissingArtifactDescriptor(false);
        session.setIgnoreInvalidArtifactDescriptor(false);
        session.setUpdatePolicy("always");
        session.setConfigProperty("aether.connector.userAgent", (Object)this.configuration.getUserAgent());
        session.setSystemProperty("version", null);
        session.setSystemProperty("groupId", null);
        return session;
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            return new AetherExtensionRepository(repositoryDescriptor, this, this.plexusComponentManager, this.componentManager);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + repositoryDescriptor + "]", (Throwable)e);
        }
    }
}

