/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;

public class AetherExtensionFile
implements ExtensionFile {
    private Artifact artifact;
    private AetherExtensionRepository repository;

    public AetherExtensionFile(Artifact artifact, AetherExtensionRepository repository) {
        this.repository = repository;
        this.artifact = artifact;
    }

    public long getLength() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openStream() throws IOException {
        ArtifactResult artifactResult;
        RepositoryConnector connector;
        XWikiRepositorySystemSession session = this.repository.createRepositorySystemSession();
        List<RemoteRepository> repositories = this.repository.newResolutionRepositories((RepositorySystemSession)session);
        RemoteRepository repository = repositories.get(0);
        try {
            RepositoryConnectorProvider repositoryConnectorProvider = this.repository.getRepositoryConnectorProvider();
            connector = repositoryConnectorProvider.newRepositoryConnector((RepositorySystemSession)session, repository);
        }
        catch (NoRepositoryConnectorException e) {
            throw new IOException("Failed to download artifact [" + this.artifact + "]", e);
        }
        ArtifactDownload download = new ArtifactDownload();
        download.setArtifact(this.artifact);
        download.setRepositories(repositories);
        try {
            connector.get(Arrays.asList(download), null);
        }
        finally {
            connector.close();
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setRepositories(repositories);
        artifactRequest.setArtifact(this.artifact);
        try {
            RepositorySystem repositorySystem = this.repository.getRepositorySystem();
            artifactResult = repositorySystem.resolveArtifact((RepositorySystemSession)session, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException("Failed to resolve artifact", e);
        }
        File aetherFile = artifactResult.getArtifact().getFile();
        return new AetherExtensionFileInputStream(aetherFile, session);
    }

    static class AetherExtensionFileInputStream
    extends FileInputStream {
        private XWikiRepositorySystemSession session;

        public AetherExtensionFileInputStream(File file, XWikiRepositorySystemSession session) throws FileNotFoundException {
            super(file);
            this.session = session;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.session.close();
        }
    }
}

