/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.groovy.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.groovy.GroovyCompilationCustomizer;
import org.xwiki.groovy.GroovyConfiguration;

@Component
@Singleton
public class DefaultGroovyConfiguration
implements GroovyConfiguration {
    private static final String PREFIX = "groovy.";
    @Inject
    private ConfigurationSource configuration;
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;

    @Override
    public List<String> getCompilationCustomizerNames() {
        return (List)this.configuration.getProperty("groovy.compilationCustomizers", Collections.emptyList());
    }

    @Override
    public List<CompilationCustomizer> getCompilationCustomizers() {
        ArrayList<CompilationCustomizer> customizers = new ArrayList<CompilationCustomizer>();
        for (String customizerName : this.getCompilationCustomizerNames()) {
            try {
                GroovyCompilationCustomizer customizer = (GroovyCompilationCustomizer)this.componentManager.getInstance(GroovyCompilationCustomizer.class, customizerName);
                CompilationCustomizer compilationCustomizer = customizer.createCustomizer();
                if (compilationCustomizer == null) continue;
                customizers.add(compilationCustomizer);
            }
            catch (Exception e) {
                this.logger.warn("Failed to create the Groovy Compilation Customizer named [{}]", (Object)customizerName, (Object)e);
            }
        }
        return customizers;
    }
}

