/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Role;

public class SafeArrayConverter
extends ArrayConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeArrayConverter.class);
    private final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder docBuilder = this.docFactory.newDocumentBuilder();
    private HierarchicalStreamCopier copier = new HierarchicalStreamCopier();
    private XStream xstream;

    public SafeArrayConverter(Mapper mapper, XStream xstream) throws ParserConfigurationException {
        super(mapper);
        this.xstream = xstream;
    }

    public boolean canConvert(Class type) {
        return type == Object[].class;
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Object value;
        try {
            value = super.readItem(reader, context, current);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to read field", e);
            value = null;
        }
        return value;
    }

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (item == null || item instanceof String || item instanceof Number) {
            super.writeItem(item, context, writer);
        } else if (this.isComponent(item)) {
            super.writeItem((Object)item.toString(), context, writer);
        } else {
            try {
                Document doc = this.docBuilder.newDocument();
                DomWriter domWriter = new DomWriter(doc);
                this.xstream.marshal(item, (HierarchicalStreamWriter)domWriter);
                DomReader domReader = new DomReader(doc);
                this.copier.copy((HierarchicalStreamReader)domReader, writer);
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to write field", e);
                super.writeItem((Object)item.toString(), context, writer);
            }
        }
    }

    private boolean isComponent(Object item) {
        if (item != null) {
            List interfaces = ClassUtils.getAllInterfaces(item.getClass());
            for (Class iface : interfaces) {
                if (!iface.isAnnotationPresent(Role.class)) continue;
                return true;
            }
        }
        return false;
    }
}

