/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

public class DefaultJobProgress
implements EventListener,
JobProgress {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJobProgress.class);
    private static final List<Event> EVENTS = Arrays.asList(new PushLevelProgressEvent(), new PopLevelProgressEvent(), new StepProgressEvent());
    private final String name;
    private final Stack<Level> progress = new Stack();
    private boolean ignoreNextStepProgressEvent;

    public DefaultJobProgress() {
        this.name = this.getClass().getName() + '_' + this.hashCode();
        this.progress.push(new Level(1, 0.0, 1.0));
    }

    public String getName() {
        return this.name;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object arg1, Object arg2) {
        boolean ignoreNextStep = this.ignoreNextStepProgressEvent;
        this.ignoreNextStepProgressEvent = false;
        if (event instanceof PushLevelProgressEvent) {
            this.onPushLevelProgress((PushLevelProgressEvent)event);
        } else if (event instanceof PopLevelProgressEvent) {
            this.onPopLevelProgress();
        } else if (event instanceof StepProgressEvent && !ignoreNextStep) {
            this.onStepProgress();
        }
    }

    private void onPushLevelProgress(PushLevelProgressEvent event) {
        this.progress.push(new Level(event.getSteps(), this.getOffset(), this.progress.peek().globalStepSize));
    }

    private void onStepProgress() {
        Level level = this.progress.peek();
        if (level.currentStep++ < level.steps) {
            level.globalOffset += level.globalStepSize;
            level.levelOffset += level.localStepSize;
        } else {
            LOGGER.warn("StepProgressEvent was fired too many times: [{}] instead of [{}]. The number of times StepProgressEvent is fired must match the number of steps passed to PushLevelProgressEvent.", (Object)level.currentStep, (Object)level.steps);
        }
    }

    private void onPopLevelProgress() {
        if (this.progress.size() > 1) {
            this.progress.pop();
            this.onStepProgress();
            this.ignoreNextStepProgressEvent = true;
        } else {
            LOGGER.warn("PopLevelProgressEvent was fired too many times. Don't forget to match each PopLevelProgressEvent with a PushLevelProgressEvent.");
        }
    }

    @Override
    public double getOffset() {
        return this.progress.peek().globalOffset;
    }

    @Override
    public double getCurrentLevelOffset() {
        return this.progress.peek().levelOffset;
    }

    static class Level {
        public double globalOffset;
        public double levelOffset;
        public double globalStepSize;
        public double localStepSize;
        public int currentStep;
        public int steps;

        public Level(int steps, double offset, double parentSize) {
            this.steps = steps;
            this.globalOffset = offset;
            this.globalStepSize = parentSize / (double)steps;
            this.localStepSize = 1.0 / (double)steps;
        }
    }
}

