/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.Logger;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LoggerListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;

public abstract class AbstractJobStatus<R extends Request>
implements JobStatus {
    private final transient ReentrantLock askLock = new ReentrantLock();
    private final transient Condition answered = this.askLock.newCondition();
    private final transient DefaultJobProgress progress = new DefaultJobProgress();
    private final transient ObservationManager observationManager;
    private final transient LoggerManager loggerManager;
    private volatile transient Object question;
    private transient LoggerListener logListener;
    private LogQueue logs;
    private JobStatus.State state = JobStatus.State.NONE;
    private R request;
    private Date startDate;
    private Date endDate;
    private boolean subJob;

    public AbstractJobStatus(R request, ObservationManager observationManager, LoggerManager loggerManager, boolean subJob) {
        this.request = request;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
        this.subJob = subJob;
        this.logs = new LogQueue();
    }

    public void startListening() {
        this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.progress));
        this.logListener = new LoggerListener(LoggerListener.class.getName() + '_' + this.hashCode(), (Logger)this.logs);
        if (this.subJob) {
            this.observationManager.addListener((EventListener)this.logListener);
        } else {
            this.loggerManager.pushLogListener((EventListener)this.logListener);
        }
    }

    public void stopListening() {
        if (this.subJob) {
            this.observationManager.removeListener(this.logListener.getName());
        } else {
            this.loggerManager.popLogListener();
        }
        this.observationManager.removeListener(this.progress.getName());
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogQueue getLog() {
        return this.logs;
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ask(Object question) throws InterruptedException {
        this.question = question;
        this.askLock.lockInterruptibly();
        try {
            this.state = JobStatus.State.WAITING;
            this.answered.await();
            this.state = JobStatus.State.RUNNING;
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Object getQuestion() {
        return this.question;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answered() {
        this.askLock.lock();
        this.question = null;
        try {
            this.answered.signal();
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    @Deprecated
    public List<LogEvent> getLog(LogLevel level) {
        return this.logs.getLogs(level);
    }
}

