/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.job.internal.JobStatusSerializer;
import org.xwiki.job.internal.JobStatusStorage;

@Component
@Singleton
public class DefaultJobStatusStorage
implements JobStatusStorage,
Initializable {
    private static final String FILENAME_STATUS = "status.xml";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String FOLDER_NULL = "&null";
    private static final JobStatus NOSTATUS = new DefaultJobStatus<Object>(null, null, null, false);
    @Inject
    private JobManagerConfiguration configuration;
    @Inject
    private Logger logger;
    private Map<List<String>, JobStatus> cache;
    private JobStatusSerializer serializer;
    private ExecutorService executorService;

    public void initialize() throws InitializationException {
        try {
            this.serializer = new JobStatusSerializer();
            this.repair();
        }
        catch (Exception e) {
            this.logger.error("Failed to load jobs", (Throwable)e);
        }
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("Job status serializer").daemon(true).priority(1).build();
        this.executorService = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
        this.cache = Collections.synchronizedMap(new LRUMap(50));
    }

    private String encode(String name) {
        String encoded;
        if (name != null) {
            try {
                encoded = URLEncoder.encode(name, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                encoded = name;
            }
        } else {
            encoded = FOLDER_NULL;
        }
        return encoded;
    }

    private void repair() {
        File folder = this.configuration.getStorage();
        if (folder.exists()) {
            this.repairFolder(folder);
        }
    }

    private void repairFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.repairFolder(file);
                continue;
            }
            if (!file.getName().equals(FILENAME_STATUS)) continue;
            try {
                File properFolder;
                JobStatus status = this.loadStatus(folder);
                if (status == null || folder.equals(properFolder = this.getJobFolder(status.getRequest().getId()))) continue;
                try {
                    FileUtils.moveFileToDirectory((File)file, (File)properFolder, (boolean)true);
                }
                catch (IOException e) {
                    this.logger.error("Failed to move job status file", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status in folder [{}]", (Object)folder, (Object)e);
            }
        }
    }

    private JobStatus loadStatus(List<String> id) {
        return this.loadStatus(this.getJobFolder(id));
    }

    private JobStatus loadStatus(File folder) {
        File statusFile = new File(folder, FILENAME_STATUS);
        if (statusFile.exists()) {
            return this.loadJobStatus(statusFile);
        }
        return null;
    }

    private JobStatus loadJobStatus(File statusFile) {
        return this.serializer.read(statusFile);
    }

    private File getJobFolder(List<String> id) {
        File folder = this.configuration.getStorage();
        if (id != null) {
            for (String idElement : id) {
                folder = new File(folder, this.encode(idElement));
            }
        }
        return folder;
    }

    private void saveJobStatus(JobStatus status) throws IOException {
        File statusFile = this.getJobFolder(status.getRequest().getId());
        statusFile = new File(statusFile, FILENAME_STATUS);
        this.serializer.write(status, statusFile);
    }

    @Override
    public JobStatus getJobStatus(String id) {
        return this.getJobStatus(id != null ? Arrays.asList(id) : (List<String>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(List<String> id) {
        JobStatus status = this.cache.get(id);
        if (status == null) {
            DefaultJobStatusStorage defaultJobStatusStorage = this;
            synchronized (defaultJobStatusStorage) {
                status = this.cache.get(id);
                if (status == null) {
                    try {
                        status = this.loadStatus(id);
                        this.cache.put(id, status);
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to load job status for id [{}]", id, (Object)e);
                        this.cache.put(id, NOSTATUS);
                    }
                }
            }
        }
        return status == NOSTATUS ? null : status;
    }

    @Override
    public void store(JobStatus status) {
        if (status != null && status.getRequest() != null && status.getRequest().getId() != null) {
            this.cache.put(status.getRequest().getId(), status);
            if (status instanceof Serializable) {
                try {
                    this.saveJobStatus(status);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to save job status [{}]", (Object)status, (Object)e);
                }
            }
        }
    }

    @Override
    public void storeAsync(JobStatus status) {
        this.executorService.execute(new JobStatusSerializerRunnable(status));
    }

    @Override
    public JobStatus remove(String id) {
        return this.remove(Arrays.asList(id));
    }

    @Override
    public JobStatus remove(List<String> id) {
        File jobFolder = this.getJobFolder(id);
        if (jobFolder.exists()) {
            JobStatus status;
            try {
                status = this.loadStatus(jobFolder);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status with id [{}]", id, (Object)e);
                status = null;
            }
            try {
                FileUtils.deleteDirectory((File)jobFolder);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete job folder [{}]", (Object)jobFolder, (Object)e);
            }
            this.cache.remove(id);
            return status;
        }
        this.cache.remove(id);
        return null;
    }

    class JobStatusSerializerRunnable
    implements Runnable {
        private final JobStatus status;

        public JobStatusSerializerRunnable(JobStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            DefaultJobStatusStorage.this.store(this.status);
        }
    }
}

