/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xwiki.job.internal.xstream.DataHolderWrapper;
import org.xwiki.job.internal.xstream.SafeXStream;
import org.xwiki.job.internal.xstream.XStreamUtils;

public class SafeArrayConverter
extends ArrayConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeArrayConverter.class);
    private final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuilder;
    private final HierarchicalStreamCopier copier;
    private SafeXStream xstream;

    public SafeArrayConverter(SafeXStream xstream) {
        super(xstream.getMapper());
        try {
            this.docBuilder = this.docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Failed to create a DocumentBuilder");
        }
        this.copier = new HierarchicalStreamCopier();
        this.xstream = xstream;
    }

    public boolean canConvert(Class type) {
        return type == Object[].class;
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Object value;
        try {
            value = super.readItem(reader, context, current);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to read field", e);
            value = null;
        }
        return value;
    }

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (XStreamUtils.isSafeType(item) || this.docBuilder == null) {
            super.writeItem(item, context, writer);
        } else if (XStreamUtils.isComponent(item)) {
            super.writeItem((Object)item.toString(), context, writer);
        } else {
            try {
                Document doc = this.docBuilder.newDocument();
                DomWriter domWriter = new DomWriter(doc);
                this.xstream.marshal(item, (HierarchicalStreamWriter)domWriter, new DataHolderWrapper((DataHolder)context));
                DomReader domReader = new DomReader(doc);
                this.copier.copy((HierarchicalStreamReader)domReader, writer);
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to write field", e);
                super.writeItem((Object)item.toString(), context, writer);
            }
        }
    }
}

