/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.xwiki.job.JobGroupPath;

public class JobGroupPathLockTree {
    private final Map<JobGroupPath, ReadWriteLock> tree = new ConcurrentHashMap<JobGroupPath, ReadWriteLock>();

    private synchronized ReadWriteLock getLock(JobGroupPath key) {
        ReadWriteLock lock = this.tree.get(key);
        if (lock == null) {
            lock = new ReentrantReadWriteLock(true);
            this.tree.put(key, lock);
        }
        return lock;
    }

    public void lock(JobGroupPath key) {
        this.getLock(key).writeLock().lock();
        for (JobGroupPath path = key.getParent(); path != null; path = path.getParent()) {
            this.getLock(path).readLock().lock();
        }
    }

    public void unlock(JobGroupPath key) {
        this.getLock(key).writeLock().unlock();
        for (JobGroupPath path = key.getParent(); path != null; path = path.getParent()) {
            this.getLock(path).readLock().unlock();
        }
    }
}

