/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.job.event.status.JobProgressStep;
import org.xwiki.logging.Message;

public class DefaultJobProgressStep
implements JobProgressStep {
    protected final transient DefaultJobProgressStep parent;
    protected transient Object source;
    protected transient Object levelSource;
    protected final Message message;
    protected final int index;
    protected double offset;
    protected int maximumChildren = -1;
    protected double childSize;
    protected List<DefaultJobProgressStep> children;
    private final long startTime;
    private boolean finished;
    private boolean levelFinished;
    private long elapsedTime;

    public DefaultJobProgressStep(Message message, Object source, DefaultJobProgressStep parent) {
        this.message = message;
        this.parent = parent;
        this.source = source;
        if (this.parent != null) {
            this.index = parent.children.size();
            this.startTime = this.index == 0 ? parent.startTime : System.nanoTime();
        } else {
            this.index = 0;
            this.startTime = System.nanoTime();
        }
        this.offset = 0.0;
    }

    public boolean isVirtual() {
        return this.getParent() != null && this.getParent().getChildren().isEmpty();
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public DefaultJobProgressStep getParent() {
        return this.parent;
    }

    public List<DefaultJobProgressStep> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public long getElapsedTime() {
        return this.isFinished() ? this.elapsedTime : System.nanoTime() - this.startTime;
    }

    private void assertModifiable() {
        if (this.isFinished()) {
            throw new UnsupportedOperationException("Step is closed");
        }
    }

    public DefaultJobProgressStep addStep(Message stepMessage, Object newStepSource) {
        this.assertModifiable();
        if (this.children == null) {
            this.children = new ArrayList<DefaultJobProgressStep>();
        }
        DefaultJobProgressStep step = new DefaultJobProgressStep(stepMessage, newStepSource, this);
        this.children.add(step);
        if (this.maximumChildren <= 0) {
            this.childSize = 1.0 / (double)this.children.size();
            double newOffset = this.childSize * (double)(this.children.size() - 1);
            this.move(newOffset - this.offset);
        }
        return step;
    }

    public DefaultJobProgressStep addLevel(Object newLevelSource) {
        return this.addLevel(0, newLevelSource);
    }

    public DefaultJobProgressStep addLevel(int steps, Object newLevelSource) {
        this.assertModifiable();
        this.maximumChildren = steps;
        this.levelSource = newLevelSource;
        if (steps > 0) {
            this.childSize = 1.0 / (double)steps;
        }
        this.children = this.maximumChildren > 0 ? new ArrayList<DefaultJobProgressStep>(this.maximumChildren) : new ArrayList<DefaultJobProgressStep>();
        return new DefaultJobProgressStep(null, newLevelSource, this);
    }

    public void move(double size) {
        this.assertModifiable();
        if (size != 0.0) {
            this.offset += size;
            double actualSize = size;
            if (this.offset > 1.0) {
                actualSize -= this.offset - 1.0;
                this.offset = 1.0;
            }
            if (this.parent != null && actualSize != 0.0) {
                this.parent.move(actualSize *= this.parent.childSize);
            }
        }
    }

    public DefaultJobProgressStep nextStep(Message stepMessage, Object newStepSource) {
        this.assertModifiable();
        this.finishStep();
        return this.addStep(stepMessage, newStepSource);
    }

    public void finishStep() {
        if (this.children != null && !this.children.isEmpty()) {
            this.children.get(this.children.size() - 1).finish();
        }
    }

    public boolean isFinished() {
        return this.finished || this.isVirtual();
    }

    public boolean isLevelFinished() {
        return this.levelFinished || this.isVirtual();
    }

    public void finishLevel() {
        if (!this.isLevelFinished()) {
            this.finishStep();
            this.move(1.0 - this.offset);
            this.levelSource = null;
            this.levelFinished = true;
        }
    }

    public void finish() {
        if (!this.isFinished()) {
            this.finishLevel();
            this.elapsedTime = this.getElapsedTime();
            this.source = null;
            this.finished = true;
        }
    }
}

