/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.annotation.Serializable;

public final class XStreamUtils {
    private static final List<Class<?>> UNSERIALIZABLE_CLASSES = Arrays.asList(Logger.class, Provider.class, ComponentManager.class);

    private XStreamUtils() {
    }

    public static boolean isSafeType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray() || obj instanceof Enum;
    }

    public static boolean isSerializable(Object item) {
        if (item != null) {
            Serializable serializable = item.getClass().getAnnotation(Serializable.class);
            if (serializable != null) {
                return serializable.value();
            }
            if (item instanceof java.io.Serializable) {
                return true;
            }
            if (!item.getClass().isAnnotationPresent(Component.class)) {
                for (Class<?> clazz : UNSERIALIZABLE_CLASSES) {
                    if (!clazz.isInstance(item)) continue;
                    return false;
                }
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static void serializeField(String name, Class<?> defaultType, Object value, HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        if (value != null) {
            writer.startNode(name);
            Class<?> actualType = value.getClass();
            if (actualType != defaultType) {
                String serializedClassName = mapper.serializedClass(actualType);
                String attributeName = mapper.aliasForSystemAttribute("class");
                if (attributeName != null) {
                    writer.addAttribute(attributeName, serializedClassName);
                }
            }
            context.convertAnother(value);
            writer.endNode();
        }
    }
}

