/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.logging.Logger;

public class ForbiddenThreadsFilter
extends Filter<ILoggingEvent> {
    private Set<Thread> threads = Collections.newSetFromMap(new ConcurrentHashMap());

    public FilterReply decide(ILoggingEvent event) {
        if (event.getMarker() != Logger.ROOT_MARKER && this.threads.contains(Thread.currentThread())) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    public void addThread(Thread thread) {
        this.threads.add(thread);
    }

    public void removeThread(Thread thread) {
        this.threads.remove(thread);
    }
}

