/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.management.internal;

import java.lang.management.ManagementFactory;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.management.JMXBeanRegistration;

@Component
@Singleton
public class DefaultJMXBeanRegistration
extends AbstractLogEnabled
implements JMXBeanRegistration {
    public void registerMBean(Object mbean, String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName("org.xwiki:" + name);
            mbs.registerMBean(mbean, oname);
            this.getLogger().debug("Registered resource with name [" + name + "] successfully");
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to register resource with name [" + name + "]. Reason = [" + e.getMessage() + "]");
        }
    }
}

