/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.properties;

/**
 * Thrown when a mandatory field is not found in the map of value to populate.
 * 
 * @version $Id: PropertyMandatoryException.java 24878 2009-11-05 16:22:55Z tmortagne $
 * @since 2.0M2
 */
public class PropertyMandatoryException extends PropertyException
{
    /**
     * Class ID for serialization.
     */
    private static final long serialVersionUID = 1L;

    /**
     * @param propertyName the name of the mandatory property
     */
    public PropertyMandatoryException(String propertyName)
    {
        super("Property [" + propertyName + "] mandatory");
    }
}
