/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import java.awt.Color;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component(value="java.awt.Color")
public class ColorConverter
extends AbstractConverter {
    private static final String USAGE = "Color value should be in the form of '#xxxxxx' or 'r,g,b'";

    protected Color convertToType(Type type, Object value) {
        Color color = null;
        if (value != null) {
            color = this.parse(value.toString());
        }
        return color;
    }

    protected String convertToString(Object value) {
        Color colorValue = (Color)value;
        return MessageFormat.format("{0},{1},{2}", colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue());
    }

    protected Color parseRGB(String value) {
        StringTokenizer items = new StringTokenizer(value, ",");
        try {
            int red = 0;
            if (items.hasMoreTokens()) {
                red = Integer.parseInt(items.nextToken().trim());
            }
            int green = 0;
            if (items.hasMoreTokens()) {
                green = Integer.parseInt(items.nextToken().trim());
            }
            int blue = 0;
            if (items.hasMoreTokens()) {
                blue = Integer.parseInt(items.nextToken().trim());
            }
            return new Color(red, green, blue);
        }
        catch (NumberFormatException ex) {
            throw new ConversionException(value + "is not a valid RGB colo", ex);
        }
    }

    protected Color parseHtml(String value) {
        if (value.length() != 7) {
            throw new ConversionException(USAGE);
        }
        int colorValue = 0;
        try {
            colorValue = Integer.parseInt(value.substring(1), 16);
            return new Color(colorValue);
        }
        catch (NumberFormatException ex) {
            throw new ConversionException(value + "is not a valid Html color", ex);
        }
    }

    public Color parse(String value) {
        if (value.length() <= 1) {
            throw new ConversionException(USAGE);
        }
        if (value.charAt(0) == '#') {
            return this.parseHtml(value);
        }
        if (value.indexOf(44) != -1) {
            return this.parseRGB(value);
        }
        throw new ConversionException(USAGE);
    }
}

