/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.converter;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionConverter
extends AbstractConverter {
    protected static final char QUOTECHAR = '\"';
    protected static final String QUOTESTRING = "\"";
    @Inject
    private ConverterManager converterManager;
    private char delimiter = (char)44;
    private char[] allowedChars = new char[]{'.', '-'};

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setAllowedChars(char[] allowedChars) {
        this.allowedChars = allowedChars;
    }

    @Override
    protected <T> T convertToType(Type targetType, Object value) {
        Type genericType = null;
        if (targetType instanceof ParameterizedType) {
            genericType = ((ParameterizedType)targetType).getActualTypeArguments()[0];
        }
        return (T)this.parseElements(value.toString(), genericType);
    }

    protected Collection parseElements(String value, Type genericType) {
        String cleanedValue = this.cleanValue(value);
        try {
            int ttype;
            StreamTokenizer st = this.createStreamTokenizer(cleanedValue);
            Collection list = this.newCollection();
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                String objValue = st.sval;
                if (genericType != null && genericType != String.class) {
                    objValue = this.converterManager.convert(genericType, objValue);
                }
                list.add(objValue);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return list;
        }
        catch (IOException e) {
            throw new ConversionException("Error converting from String: " + e.getMessage(), e);
        }
    }

    protected Collection newCollection() {
        return new ArrayList();
    }

    private String cleanValue(String value) {
        String cleanedValue = value.trim();
        if (cleanedValue.startsWith("{") && cleanedValue.endsWith("}")) {
            cleanedValue = cleanedValue.substring(1, cleanedValue.length() - 1);
        }
        return cleanedValue;
    }

    protected StreamTokenizer createStreamTokenizer(String value) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(value));
        st.whitespaceChars(this.getDelimiter(), this.getDelimiter());
        st.ordinaryChars(48, 57);
        st.wordChars(48, 57);
        for (int i = 0; i < this.allowedChars.length; ++i) {
            st.ordinaryChars(this.allowedChars[i], this.allowedChars[i]);
            st.wordChars(this.allowedChars[i], this.allowedChars[i]);
        }
        return st;
    }

    @Override
    protected String convertToString(Object value) {
        StringBuilder sb = new StringBuilder();
        Collection collection = (Collection)value;
        for (Object element : collection) {
            String elementString;
            if (sb.length() > 0) {
                sb.append(this.getDelimiter());
            }
            if ((elementString = (String)this.getConverterManager().convert((Type)((Object)String.class), element)) == null) continue;
            boolean containsDelimiter = StringUtils.contains((String)elementString, (char)this.getDelimiter());
            if (containsDelimiter) {
                sb.append(QUOTESTRING);
            }
            sb.append(elementString != null ? elementString.replace("\\", "\\\\").replace(QUOTESTRING, "\\\"").replace("'", "\\'") : null);
            if (!containsDelimiter) continue;
            sb.append(QUOTESTRING);
        }
        return sb.toString();
    }
}

