/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class DefaultConverterManager
implements ConverterManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="enum")
    private Converter enumConverter;
    @Inject
    private Converter defaultConverter;
    @Inject
    private Logger logger;

    @Override
    public <T> T convert(Type targetType, Object value) {
        Converter converter = this.lookupConverter(targetType);
        if (converter != null) {
            return converter.convert(targetType, value);
        }
        throw new ConversionException("Cannot find Converter to convert value [" + value + "] to type [" + targetType + "] ");
    }

    private Converter lookupConverter(Type targetType) {
        String typeName;
        Converter converter = null;
        String typeGenericName = this.getTypeGenericName(targetType);
        if (this.componentManager.hasComponent(Converter.class, typeGenericName)) {
            try {
                converter = (Converter)this.componentManager.getInstance(Converter.class, typeGenericName);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to find a specific Converter for type [" + typeGenericName + "]", (Throwable)e);
            }
        }
        if (converter == null && targetType instanceof ParameterizedType && this.componentManager.hasComponent(Converter.class, typeName = this.getTypeName(targetType))) {
            try {
                converter = (Converter)this.componentManager.getInstance(Converter.class, typeName);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to find a specific Converter for class [" + typeName + "]", (Throwable)e);
            }
        }
        if (converter == null) {
            if (targetType instanceof Class && Enum.class.isAssignableFrom((Class)targetType)) {
                converter = this.enumConverter;
            } else {
                this.logger.debug("Using the default Converter for type [{}]", (Object)typeGenericName);
                converter = this.defaultConverter;
            }
        }
        return converter;
    }

    private String getTypeName(Type type) {
        String name = type instanceof Class ? ((Class)type).getName() : (type instanceof ParameterizedType ? ((Class)((ParameterizedType)type).getRawType()).getName() : type.toString());
        return name;
    }

    private String getTypeGenericName(Type type) {
        ParameterizedType parameterizedType;
        Type[] generics;
        StringBuilder sb = new StringBuilder(this.getTypeName(type));
        if (type instanceof ParameterizedType && (generics = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            sb.append('<');
            for (int i = 0; i < generics.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getTypeGenericName(generics[i]));
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

