/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.properties.internal.converter;

import java.lang.reflect.Type;
import java.util.HashSet;

import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.collection.AbstractSetConverter;

/**
 * @version $Id: b462b0730f31e9eaaaf4684f3e8110419a9644bf $
 * @since 5.2M1
 */
@Component
@Singleton
public class HashSetConverter extends AbstractSetConverter<HashSet>
{
    @Override
    protected <G extends HashSet> G convertToType(Type targetType, Object value)
    {
        if (value instanceof HashSet) {
            return (G) value;
        }

        return super.convertToType(targetType, value);
    }

    @Override
    protected HashSet newCollection(Type targetType)
    {
        return new HashSet();
    }
}
