/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.script.internal.safe;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.xwiki.script.internal.safe.AbstractSafeObject;
import org.xwiki.script.internal.safe.SafeIterator;
import org.xwiki.script.internal.safe.ScriptSafeProvider;

public class SafeCollection<E, C extends Collection<E>>
extends AbstractSafeObject<C>
implements Collection<E> {
    protected Constructor<? extends E> safeConstructor;

    public SafeCollection(C collection, ScriptSafeProvider<?> safeProvider, Constructor<? extends E> safeConstructor) {
        super(collection, safeProvider);
        this.safeConstructor = safeConstructor;
    }

    protected E safeElement(E element) {
        if (this.safeConstructor != null) {
            try {
                return this.safeConstructor.newInstance(element, this.safeProvider);
            }
            catch (Exception e) {
                return (E)this.safe(element);
            }
        }
        return (E)this.safe(element);
    }

    @Override
    public int size() {
        return ((Collection)this.getWrapped()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.getWrapped()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.getWrapped()).contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new SafeIterator(((Collection)this.getWrapped()).iterator(), this.safeProvider, this.safeConstructor);
    }

    @Override
    public Object[] toArray() {
        Object[] copy = ((Collection)this.getWrapped()).toArray();
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.safe(copy[i]);
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] copy = ((Collection)this.getWrapped()).toArray(a);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.safe(copy[i]);
        }
        return copy;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Collection)this.getWrapped()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }
}

