/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDeclaration;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.internal.MockConfigurationSource;

public class ComponentRegistrator {
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();

    public void registerComponent(Type roleType, Object instance, ComponentManager componentManager) throws Exception {
        this.registerComponent(roleType, null, instance, componentManager);
    }

    public void registerComponent(Type roleType, String roleHint, Object instance, ComponentManager componentManager) throws Exception {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRoleType(roleType);
        if (roleHint != null) {
            descriptor.setRoleHint(roleHint);
        }
        componentManager.registerComponent((ComponentDescriptor)descriptor, instance);
    }

    public void registerComponents(Class<?> testClass, ComponentManager componentManager) {
        AllComponents allComponentsAnnotation = testClass.getAnnotation(AllComponents.class);
        if (allComponentsAnnotation != null) {
            this.loader.initialize(componentManager, testClass.getClassLoader());
        } else {
            ComponentList componentListAnnotation = testClass.getAnnotation(ComponentList.class);
            if (componentListAnnotation != null) {
                ArrayList<ComponentDeclaration> componentDeclarations = new ArrayList<ComponentDeclaration>();
                for (Class<?> componentClass : componentListAnnotation.value()) {
                    componentDeclarations.add(new ComponentDeclaration(componentClass.getName()));
                }
                this.loader.initialize(componentManager, testClass.getClassLoader(), componentDeclarations);
            }
        }
    }

    public MemoryConfigurationSource registerMemoryConfigurationSource(ComponentManager componentManager) throws Exception {
        MockConfigurationSource configurationSource = new MockConfigurationSource();
        componentManager.registerComponent(MockConfigurationSource.getDescriptor(null), (Object)configurationSource);
        componentManager.registerComponent(MockConfigurationSource.getDescriptor("xwikiproperties"), (Object)configurationSource);
        return configurationSource;
    }
}

