/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.mockito;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.mockito.MockitoComponentManagerRule;

public class MockitoComponentMockingRule<T>
extends MockitoComponentManagerRule {
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private Logger mockLogger;
    private RoleHint<T> mockedComponentHint;
    private Class<?> componentImplementationClass;
    private List<Class<?>> excludedComponentRoleDependencies = new ArrayList();
    private Type componentRoleType;
    private String componentRoleHint;

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass) {
        this.componentImplementationClass = componentImplementationClass;
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this(componentImplementationClass);
        this.excludedComponentRoleDependencies.addAll(excludedComponentRoleDependencies);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this(componentImplementationClass, excludedComponentRoleDependencies);
        this.componentRoleType = componentRoleType;
        this.componentRoleHint = componentRoleHint;
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this(componentImplementationClass, componentRoleType, null, excludedComponentRoleDependencies);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint) {
        this(componentImplementationClass);
        this.componentRoleType = componentRoleType;
        this.componentRoleHint = componentRoleHint;
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType) {
        this(componentImplementationClass, componentRoleType, (String)null);
    }

    @Override
    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                MockitoComponentMockingRule.this.before(base, method, target);
                try {
                    base.evaluate();
                }
                finally {
                    MockitoComponentMockingRule.this.after(base, method, target);
                }
            }
        };
    }

    @Override
    protected void before(Statement base, FrameworkMethod method, Object target) throws Throwable {
        super.before(base, method, target);
        this.mockComponent(target);
    }

    private void mockComponent(Object testInstance) throws Exception {
        for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(this.componentImplementationClass, this.findComponentRoleType())) {
            if ((this.componentRoleHint == null || !this.componentRoleHint.equals(descriptor.getRoleHint())) && this.componentRoleHint != null) continue;
            this.registerMockDependencies(descriptor);
            this.registerComponent(descriptor);
            this.mockedComponentHint = new RoleHint(descriptor.getRoleType(), descriptor.getRoleHint());
            break;
        }
    }

    protected Object createLogger(Class<?> instanceClass) {
        Object logger;
        if (!this.excludedComponentRoleDependencies.contains(Logger.class) && this.componentImplementationClass == instanceClass) {
            logger = Mockito.mock(Logger.class, (String)instanceClass.getName());
            this.mockLogger = (Logger)logger;
        } else {
            logger = super.createLogger(instanceClass);
        }
        return logger;
    }

    private void registerMockDependencies(ComponentDescriptor<T> descriptor) throws Exception {
        Collection dependencyDescriptors = descriptor.getComponentDependencies();
        for (ComponentDependency dependencyDescriptor : dependencyDescriptors) {
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType());
            if (this.excludedComponentRoleDependencies.contains(roleTypeClass) || Logger.class == roleTypeClass || roleTypeClass.isAssignableFrom(List.class) || roleTypeClass.isAssignableFrom(Map.class) || this.hasComponent(dependencyDescriptor.getRoleType(), dependencyDescriptor.getRoleHint())) continue;
            DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
            cd.setRoleType(dependencyDescriptor.getRoleType());
            cd.setRoleHint(dependencyDescriptor.getRoleHint());
            this.registerComponent((ComponentDescriptor)cd, Mockito.mock((Class)ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType()), (String)dependencyDescriptor.getName()));
        }
    }

    private Type findComponentRoleType() {
        Type type;
        Set componentRoleTypes = this.loader.findComponentRoleTypes(this.componentImplementationClass);
        if (this.componentRoleType != null) {
            if (!componentRoleTypes.contains(this.componentRoleType)) {
                throw new RuntimeException("Specified Component Role not found in component");
            }
            type = this.componentRoleType;
        } else {
            if (componentRoleTypes.isEmpty()) {
                throw new RuntimeException(String.format("Couldn't find roles for component [%s]", this.componentRoleType));
            }
            if (componentRoleTypes.size() > 1) {
                throw new RuntimeException("Components with several roles must explicitly specify which role to use.");
            }
            type = (Type)componentRoleTypes.iterator().next();
        }
        return type;
    }

    public T getComponentUnderTest() throws ComponentLookupException {
        return (T)this.getInstance(this.mockedComponentHint.getRoleType(), this.mockedComponentHint.getHint());
    }

    public Logger getMockedLogger() {
        return this.mockLogger;
    }
}

