/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.runner.RunWith;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.EmbeddableComponentManager;

@RunWith(value=JMock.class)
public abstract class AbstractMockingTestCase {
    private Mockery mockery = new JUnit4Mockery();

    public Mockery getMockery() {
        return this.mockery;
    }

    public abstract EmbeddableComponentManager getComponentManager() throws Exception;

    public <T> T registerMockComponent(Class<T> role, String hint, String mockId) throws Exception {
        DefaultComponentDescriptor<T> descriptor = this.createComponentDescriptor(role);
        descriptor.setRoleHint(hint);
        return this.registerMockComponent((ComponentDescriptor<T>)descriptor, mockId);
    }

    public <T> T registerMockComponent(Class<T> role, String hint) throws Exception {
        return this.registerMockComponent(role, hint, null);
    }

    public <T> T registerMockComponent(Class<T> role) throws Exception {
        return this.registerMockComponent((ComponentDescriptor<T>)this.createComponentDescriptor(role));
    }

    private <T> T registerMockComponent(ComponentDescriptor<T> descriptor) throws Exception {
        return this.registerMockComponent(descriptor, null);
    }

    private <T> T registerMockComponent(ComponentDescriptor<T> descriptor, String mockId) throws Exception {
        Object instance = mockId != null ? this.getMockery().mock(descriptor.getRole(), mockId) : this.getMockery().mock(descriptor.getRole());
        this.getComponentManager().registerComponent(descriptor, instance);
        return (T)instance;
    }

    private <T> DefaultComponentDescriptor<T> createComponentDescriptor(Class<T> role) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(role);
        return descriptor;
    }
}

