/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.test.AbstractMockingTestCase;
import org.xwiki.test.MockConfigurationSource;
import org.xwiki.test.XWikiComponentInitializer;

public abstract class AbstractComponentTestCase
extends AbstractMockingTestCase {
    private XWikiComponentInitializer initializer = new XWikiComponentInitializer();
    private ComponentAnnotationLoader componentLoader;

    @Before
    public void setUp() throws Exception {
        this.initializer.initializeConfigurationSource();
        this.registerComponents();
        this.initializer.initializeExecution();
    }

    @After
    public void tearDown() throws Exception {
        this.initializer.shutdown();
    }

    protected void registerComponents() throws Exception {
    }

    @Override
    public EmbeddableComponentManager getComponentManager() throws Exception {
        return this.initializer.getComponentManager();
    }

    public MockConfigurationSource getConfigurationSource() {
        return this.initializer.getConfigurationSource();
    }

    public void registerComponent(Class<?> componentClass) throws Exception {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        List descriptors = this.componentLoader.getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.getComponentManager().registerComponent(descriptor);
        }
    }
}

