/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Before;
import org.slf4j.Logger;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.AbstractMockingTestCase;
import org.xwiki.test.annotation.MockingRequirement;

public abstract class AbstractMockingComponentTestCase
extends AbstractMockingTestCase {
    private EmbeddableComponentManager componentManager;
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private Map<Class, Logger> mockLoggers = new HashMap<Class, Logger>();

    public Logger getMockLogger(Class<?> mockRequirementInstanceClass) {
        return this.mockLoggers.get(mockRequirementInstanceClass);
    }

    public Logger getMockLogger() {
        if (this.mockLoggers.size() == 1) {
            return this.mockLoggers.values().iterator().next();
        }
        if (this.mockLoggers.size() == 0) {
            throw new RuntimeException("You have excluded the Logger from being mocked in your @MockingRequirement!");
        }
        throw new RuntimeException("When there are several @MockingRequirement annotations you muse use the getMockLogger(mockRequirementInstanceClass) signature!");
    }

    @Before
    public void setUp() throws Exception {
        this.componentManager = new MockingEmbeddableComponentManager();
        this.loader.initialize((ComponentManager)this.componentManager, this.getClass().getClassLoader());
        ArrayList<Object[]> components = new ArrayList<Object[]>();
        block0: for (Field field : ReflectionUtils.getAllFields(this.getClass())) {
            MockingRequirement mockingRequirement = field.getAnnotation(MockingRequirement.class);
            if (mockingRequirement == null) continue;
            List<Class<?>> exclusions = Arrays.asList(mockingRequirement.exceptions());
            if (!exclusions.contains(Logger.class)) {
                ((MockingEmbeddableComponentManager)this.componentManager).addMockedComponentClass(field.getType());
            }
            Type componentRoleType = this.findComponentRoleType(field, mockingRequirement.value());
            for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(field.getType(), componentRoleType)) {
                if ((mockingRequirement.hint().length() <= 0 || !mockingRequirement.hint().equals(descriptor.getRoleHint())) && mockingRequirement.hint().length() != 0) continue;
                this.registerMockDependencies(descriptor, exclusions);
                this.getComponentManager().registerComponent(descriptor);
                this.configure();
                components.add(new Object[]{field, descriptor});
                continue block0;
            }
        }
        this.setupDependencies();
        for (Object[] component : components) {
            Field field = (Field)component[0];
            ComponentDescriptor descriptor = (ComponentDescriptor)component[1];
            ReflectionUtils.setFieldValue((Object)this, (String)field.getName(), (Object)this.getComponentManager().getInstance(descriptor.getRoleType(), descriptor.getRoleHint()));
        }
    }

    protected void setupDependencies() throws Exception {
    }

    public void configure() throws Exception {
    }

    private <T> void registerMockDependencies(ComponentDescriptor<T> descriptor, List<Class<?>> exceptions) throws Exception {
        Collection dependencyDescriptors = descriptor.getComponentDependencies();
        for (ComponentDependency dependencyDescriptor : dependencyDescriptors) {
            if (exceptions.contains(ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType())) || Logger.class == ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType())) continue;
            DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
            cd.setRoleType(dependencyDescriptor.getRoleType());
            cd.setRoleHint(dependencyDescriptor.getRoleHint());
            this.componentManager.registerComponent((ComponentDescriptor)cd, this.getMockery().mock(ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType()), dependencyDescriptor.getName()));
        }
    }

    private Type findComponentRoleType(Field field, Class<?> role) {
        Type componentRoleType;
        Set componentRoleTypes = this.loader.findComponentRoleTypes(field.getType());
        if (!Object.class.getName().equals(role.getName())) {
            if (!componentRoleTypes.contains(role)) {
                throw new RuntimeException("Specified Component Role not found in component");
            }
            componentRoleType = role;
        } else {
            if (componentRoleTypes.isEmpty()) {
                throw new RuntimeException("Couldn't find roles for component [" + field.getType() + "]");
            }
            if (componentRoleTypes.size() > 1) {
                throw new RuntimeException("Components with several roles must explicitly specify which role to use.");
            }
            componentRoleType = (Type)componentRoleTypes.iterator().next();
        }
        return componentRoleType;
    }

    @Override
    public EmbeddableComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }

    private class MockingEmbeddableComponentManager
    extends EmbeddableComponentManager {
        private List<Class<?>> mockedComponentClasses = new ArrayList();

        private MockingEmbeddableComponentManager() {
        }

        public void addMockedComponentClass(Class<?> mockedComponentClass) {
            this.mockedComponentClasses.add(mockedComponentClass);
        }

        protected Object createLogger(Class<?> instanceClass) {
            Object logger;
            if (this.mockedComponentClasses.contains(instanceClass)) {
                logger = AbstractMockingComponentTestCase.this.getMockery().mock(Logger.class, instanceClass.getName());
                AbstractMockingComponentTestCase.this.mockLoggers.put(instanceClass, (Logger)logger);
            } else {
                logger = super.createLogger(instanceClass);
            }
            return logger;
        }
    }
}

