/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;

public class LogRule
implements TestRule {
    private final ListAppender<ILoggingEvent> listAppender = new ListAppender();
    private LogLevel level = LogLevel.TRACE;
    private final List<Class> loggingSources = new ArrayList<Class>();

    public Statement apply(Statement statement, Description description) {
        return new LogStatement(statement);
    }

    public void record(LogLevel level) {
        this.level = level;
    }

    public void recordLoggingForType(Class<?> type) {
        this.loggingSources.add(type);
        this.addAppenderToType(type);
    }

    public boolean contains(String logOutput) {
        List list = this.listAppender.list;
        for (ILoggingEvent event : list) {
            if (!event.getFormattedMessage().contains(logOutput)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.listAppender.list.size();
    }

    private void addAppenderToType(Class<?> type) {
        Logger logger = (Logger)LoggerFactory.getLogger(type);
        logger.addAppender(this.listAppender);
        logger.setLevel(this.level.getLevel());
    }

    public class LogStatement
    extends Statement {
        private final Statement statement;
        private final LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();

        public LogStatement(Statement statement) {
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            this.before();
            this.statement.evaluate();
            this.after();
        }

        private void before() {
            this.resetLoggingContext();
            for (Class logSource : LogRule.this.loggingSources) {
                LogRule.this.addAppenderToType(logSource);
            }
            LogRule.this.listAppender.start();
        }

        private void after() {
            LogRule.this.listAppender.stop();
            this.resetLoggingContext();
        }

        private void resetLoggingContext() {
            this.lc.reset();
        }
    }

    public static enum LogLevel {
        TRACE(Level.TRACE),
        DEBUG(Level.DEBUG),
        INFO(Level.INFO),
        WARN(Level.WARN),
        ERROR(Level.ERROR);

        private Level internalLevel;

        private LogLevel(Level level) {
            this.internalLevel = level;
        }

        public Level getLevel() {
            return this.internalLevel;
        }
    }
}

