/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.xwiki.tool.enforcer.VersionCheck;

public class ValidateDependencyVersion
implements EnforcerRule {
    private List<VersionCheck> checks = new ArrayList<VersionCheck>();

    public void addVersionCheck(VersionCheck versionCheck) {
        this.checks.add(versionCheck);
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Model model = this.getModel(helper);
        this.validateDependencies(model.getDependencies());
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            this.validateDependencies(dependencyManagement.getDependencies());
        }
    }

    private void validateDependencies(List dependencies) throws EnforcerRuleException {
        for (Object object : dependencies) {
            Dependency dependency = (Dependency)object;
            for (VersionCheck versionCheck : this.checks) {
                Pattern pattern;
                Matcher matcher;
                if (dependency.getVersion() == null || !dependency.getGroupId().startsWith(versionCheck.getGroupIdPrefix()) || (matcher = (pattern = Pattern.compile(versionCheck.getAllowedVersionRegex())).matcher(dependency.getVersion())).matches()) continue;
                throw new EnforcerRuleException("Was expecting a dependency version matching [" + versionCheck.getAllowedVersionRegex() + "] but got instead [" + dependency.getVersion() + "] for " + dependency);
            }
        }
    }

    private MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Failed to get Maven project", (Exception)((Object)e));
        }
        return project;
    }

    private Model getModel(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Model model;
        MavenProject project = this.getMavenProject(helper);
        FileReader reader = null;
        try {
            reader = new FileReader(project.getFile());
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            model = xpp3Reader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Failed to read pom file [" + project.getFile() + "]", e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception ee) {
                    throw new EnforcerRuleException("Failed to close stream after reading pom file [" + project.getFile() + "]", ee);
                }
            }
        }
        return model;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "";
    }
}

