/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.apache.maven.plugins.enforcer.BannedDependencies;

public class XWikiBannedDependencies
extends BannedDependencies {
    protected boolean compareDependency(String[] pattern, Artifact artifact) throws EnforcerRuleException {
        boolean result = false;
        if (pattern.length > 0) {
            result = artifact.getGroupId().matches(pattern[0]);
        }
        if (result && pattern.length > 1) {
            result = artifact.getArtifactId().matches(pattern[1]);
        }
        if (result && pattern.length > 2) {
            if (pattern[2].equals("*") || artifact.getVersion().equals(pattern[2])) {
                result = true;
            } else {
                try {
                    result = AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)pattern[2]), (ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
                }
            }
        }
        if (result && pattern.length > 3) {
            String type = artifact.getType();
            if (type == null || type.equals("")) {
                type = "jar";
            }
            boolean bl = result = pattern[3].equals("*") || type.equals(pattern[3]);
        }
        if (result && pattern.length > 4) {
            String scope = artifact.getScope();
            if (scope == null || scope.equals("")) {
                scope = "compile";
            }
            result = pattern[4].equals("*") || scope.equals(pattern[4]);
        }
        return result;
    }
}

