/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.spoon;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.reference.CtTypeReference;

public final class SpoonUtils {
    private SpoonUtils() {
    }

    public static Set<CtAnnotation<? extends Annotation>> getAnnotationsIncludingFromSuperclasses(CtClass<?> ctClass) {
        HashSet<CtAnnotation<? extends Annotation>> annotations = new HashSet<CtAnnotation<? extends Annotation>>();
        HashSet<String> annotationNames = new HashSet<String>();
        CtClass<?> current = ctClass;
        do {
            for (CtAnnotation ctAnnotation : current.getAnnotations()) {
                String annotationName = ctAnnotation.getType().getQualifiedName();
                if (annotationNames.contains(annotationName)) continue;
                annotations.add((CtAnnotation<? extends Annotation>)ctAnnotation);
                annotationNames.add(annotationName);
            }
        } while ((current = current.getSuperclass() == null ? null : (CtClass)current.getSuperclass().getTypeDeclaration()) != null);
        return annotations;
    }

    public static boolean hasAnnotation(CtTypeReference<?> ctTypeReference, String annotationFQN) {
        return SpoonUtils.getAnnotation(ctTypeReference, annotationFQN).isPresent();
    }

    public static Optional<CtAnnotation<? extends Annotation>> getAnnotation(CtTypeReference<?> ctTypeReference, String annotationFQN) {
        CtAnnotation result = null;
        for (CtAnnotation ctAnnotation : ctTypeReference.getTypeDeclaration().getAnnotations()) {
            if (!ctAnnotation.getType().getQualifiedName().equals(annotationFQN)) continue;
            result = ctAnnotation;
            break;
        }
        return Optional.ofNullable(result);
    }
}

