/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.xwiki.tool.xar.AbstractXARMojo;

public abstract class AbstractVerifyMojo
extends AbstractXARMojo {
    protected static final String AUTHOR = "xwiki:XWiki.Admin";
    protected static final String VERSION = "1.1";
    private static final String EXTENSION = ".xml";
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("(.*)\\..*\\.xml");
    @Parameter(property="xar.force", readonly=true)
    protected boolean force;
    @Parameter(property="xar.defaultLanguage", defaultValue="en")
    protected String defaultLanguage;
    @Parameter(property="xar.formatLicense", readonly=true)
    protected boolean formatLicense;
    @Parameter(property="xar.commons.version")
    protected String commonsVersion;
    @Parameter(property="xar.dates.skip", defaultValue="false")
    protected boolean skipDates;
    @Parameter(property="xar.dates.skip.documentList")
    protected Set<String> skipDatesDocumentList;
    @Parameter(property="xar.contentPages")
    protected List<String> contentPages;
    @Parameter(property="xar.translatablePages", defaultValue=".*/.*Translations\\.xml")
    protected List<String> translatablePages;
    @Parameter(property="xar.visibleTechnicalPages")
    protected List<String> visibleTechnicalPages;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    private List<Pattern> contentPagePatterns;
    private List<Pattern> translatablePagePatterns;
    private List<Pattern> visibleTechnicalPagePatterns;

    protected void initializePatterns() {
        this.contentPagePatterns = this.initializationPagePatterns(this.contentPages);
        this.translatablePagePatterns = this.initializationPagePatterns(this.translatablePages);
        this.visibleTechnicalPagePatterns = this.initializationPagePatterns(this.visibleTechnicalPages);
    }

    private List<Pattern> initializationPagePatterns(List<String> pageRegexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (pageRegexes != null) {
            for (String pageRegex : pageRegexes) {
                patterns.add(Pattern.compile(pageRegex));
            }
        }
        return patterns;
    }

    protected Collection<File> getXARXMLFiles() throws MojoFailureException {
        File resourcesDir = this.getResourcesDirectory();
        ArrayList<File> files = new ArrayList<File>();
        if (resourcesDir.exists()) {
            Iterator resources;
            PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
            collection.setBaseDir(resourcesDir);
            IncludeExcludeFileSelector fs = new IncludeExcludeFileSelector();
            fs.setIncludes(this.getIncludes());
            fs.setExcludes(this.getExcludes());
            IncludeExcludeFileSelector fs2 = new IncludeExcludeFileSelector();
            fs2.setExcludes(new String[]{"package.xml"});
            FileSelector[] selectors = new FileSelector[]{fs, fs2};
            collection.setFileSelectors(selectors);
            try {
                resources = collection.getResources();
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to get list of XAR XML files", (Throwable)e);
            }
            while (resources.hasNext()) {
                PlexusIoResource resource = (PlexusIoResource)resources.next();
                if (!resource.isFile()) continue;
                files.add(new File(collection.getBaseDir(), resource.getName()));
            }
        }
        return files;
    }

    protected String guessDefaultLanguage(File file, Collection<File> xwikiXmlFiles) {
        if (this.isTranslatablePage(file.getPath()) || this.isContentPage(file.getPath())) {
            return this.defaultLanguage;
        }
        String language = "";
        Matcher matcher = TRANSLATION_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            language = this.defaultLanguage;
        } else {
            String prefix = StringUtils.substringBeforeLast((String)file.getPath(), (String)EXTENSION);
            Pattern translationPattern = Pattern.compile(String.format("%s\\..*\\.xml", Pattern.quote(prefix)));
            for (File xwikiXmlFile : xwikiXmlFiles) {
                Matcher translationMatcher = translationPattern.matcher(xwikiXmlFile.getPath());
                if (!translationMatcher.matches()) continue;
                language = this.defaultLanguage;
                break;
            }
        }
        return language;
    }

    protected boolean isContentPage(String filePath) {
        return this.isMatchingPage(filePath, this.contentPagePatterns);
    }

    protected boolean isTranslatablePage(String filePath) {
        return this.isMatchingPage(filePath, this.translatablePagePatterns);
    }

    protected boolean isVisibleTechnicalPage(String filePath) {
        return this.isMatchingPage(filePath, this.visibleTechnicalPagePatterns);
    }

    private boolean isMatchingPage(String filePath, List<Pattern> patterns) {
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(filePath).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected String getXWikiCommonsVersion() {
        String version = this.commonsVersion;
        if (version == null) {
            version = this.project.getVersion();
        }
        return version;
    }

    protected void executeLicenseGoal(String goal) throws MojoExecutionException {
        Plugin licensePlugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get("com.mycila:license-maven-plugin");
        if (licensePlugin == null) {
            throw new MojoExecutionException("License plugin could not be found in <pluginManagement>");
        }
        MojoExecutor.executeMojo((Plugin)licensePlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"header"), (String)"license.txt"), MojoExecutor.element((String)MojoExecutor.name((String)"strictCheck"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinitions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinition"), (String)"license-xml-definition.xml")}), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"src/main/resources/**/*.xml")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

