/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar.internal;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XWikiDocument {
    private static final String AUTHOR_TAG = "author";
    private static final String MIMETYPE_TAG = "mimetype";
    private static final String FILENAME_TAG = "filename";
    private String reference;
    private String locale;
    private String defaultLanguage;
    private String creator;
    private String author;
    private String contentAuthor;
    private List<Map<String, String>> attachmentData;
    private String version;
    private String parent;
    private String comment;
    private String minorEdit;
    private String encoding;
    private boolean isHidden;
    private String title;
    private String syntaxId;
    private String content;
    private boolean containsTranslations;
    private List<String> translationVisibilities = new ArrayList<String>();
    private boolean datePresent;
    private boolean contentUpdateDatePresent;
    private boolean creationDatePresent;
    private boolean attachmentDatePresent;

    public void fromXML(File file) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.fromXML(reader.read(file));
    }

    public void fromXML(String file) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.fromXML(reader.read((Reader)new StringReader(file)));
    }

    public void fromXML(Document domdoc) throws DocumentException {
        this.encoding = domdoc.getXMLEncoding();
        Element rootElement = domdoc.getRootElement();
        this.reference = XWikiDocument.readDocumentReference(domdoc);
        this.locale = rootElement.attributeValue("locale");
        if (this.locale == null) {
            this.locale = XWikiDocument.readElement(rootElement, "language");
        }
        this.defaultLanguage = XWikiDocument.readElement(rootElement, "defaultLanguage");
        this.creator = XWikiDocument.readElement(rootElement, "creator");
        this.author = XWikiDocument.readElement(rootElement, AUTHOR_TAG);
        this.contentAuthor = XWikiDocument.readElement(rootElement, "contentAuthor");
        this.version = XWikiDocument.readElement(rootElement, "version");
        this.parent = XWikiDocument.readElement(rootElement, "parent");
        this.comment = XWikiDocument.readElement(rootElement, "comment");
        this.minorEdit = XWikiDocument.readElement(rootElement, "minorEdit");
        this.attachmentData = XWikiDocument.readAttachmentData(rootElement);
        this.isHidden = Boolean.parseBoolean(XWikiDocument.readElement(rootElement, "hidden"));
        this.title = XWikiDocument.readElement(rootElement, "title");
        this.syntaxId = XWikiDocument.readElement(rootElement, "syntaxId");
        this.content = XWikiDocument.readElement(rootElement, "content");
        this.datePresent = XWikiDocument.isElementPresent(rootElement, "date");
        this.contentUpdateDatePresent = XWikiDocument.isElementPresent(rootElement, "contentUpdateDate");
        this.creationDatePresent = XWikiDocument.isElementPresent(rootElement, "creationDate");
        boolean bl = this.attachmentDatePresent = rootElement.selectSingleNode("//attachment/date") != null;
        if (!rootElement.selectNodes("//object/className[text() = 'XWiki.TranslationDocumentClass']").isEmpty()) {
            this.containsTranslations = true;
            for (Node node : rootElement.selectNodes("//object/className[text() = 'XWiki.TranslationDocumentClass']/../property/scope")) {
                this.translationVisibilities.add(node.getStringValue());
            }
        }
    }

    public static String readDocumentReference(Document domdoc) throws DocumentException {
        Element rootElement = domdoc.getRootElement();
        String result = rootElement.attributeValue("reference");
        if (result == null) {
            String name = XWikiDocument.readElement(rootElement, "name");
            String space = XWikiDocument.readElement(rootElement, "web");
            if (name == null && space == null) {
                throw new DocumentException(String.format("Content doesn't point to valid wiki page XML [%s]", domdoc.getName()));
            }
            result = space == null ? name : XWikiDocument.escapeSpaceOrPageName(space) + '.' + XWikiDocument.escapeSpaceOrPageName(name);
        }
        return result;
    }

    public static boolean isElementPresent(Element rootElement, String elementName) {
        Element element = rootElement.element(elementName);
        return element != null;
    }

    public static String readElement(Element rootElement, String elementName) throws DocumentException {
        String result = null;
        Element element = rootElement.element(elementName);
        if (element != null) {
            if (!element.isTextOnly()) {
                throw new DocumentException("Unexpected non-text content found in element [" + elementName + "]");
            }
            result = element.getText();
        }
        return result;
    }

    public static List<Map<String, String>> readAttachmentData(Element rootElement) throws DocumentException {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (Element attachmentNode : rootElement.elements("attachment")) {
            String filenameValue;
            String mimetypeValue;
            HashMap<String, String> map = new HashMap<String, String>();
            String authorValue = XWikiDocument.readElement(attachmentNode, AUTHOR_TAG);
            if (authorValue != null) {
                map.put(AUTHOR_TAG, authorValue);
            }
            if ((mimetypeValue = XWikiDocument.readElement(attachmentNode, MIMETYPE_TAG)) != null) {
                map.put(MIMETYPE_TAG, mimetypeValue);
            }
            if ((filenameValue = XWikiDocument.readElement(attachmentNode, FILENAME_TAG)) != null) {
                map.put(FILENAME_TAG, filenameValue);
            }
            data.add(map);
        }
        return data;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContentAuthor() {
        return this.contentAuthor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getParent() {
        return this.parent;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMinorEdit() {
        return this.minorEdit;
    }

    public List<Map<String, String>> getAttachmentData() {
        return this.attachmentData;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean containsTranslations() {
        return this.containsTranslations;
    }

    public List<String> getTranslationVisibilities() {
        return this.translationVisibilities;
    }

    public String getSyntaxId() {
        return this.syntaxId;
    }

    public String getContent() {
        return this.content;
    }

    public static String escapeSpaceOrPageName(String name) {
        return name != null ? name.replaceAll("[\\\\\\.]", "\\\\$0") : null;
    }

    public static String getReference(File file) {
        XWikiDocument doc;
        try {
            doc = new XWikiDocument();
            doc.fromXML(file);
        }
        catch (Exception e) {
            return null;
        }
        return doc.getReference();
    }

    public boolean isDatePresent() {
        return this.datePresent;
    }

    public boolean isContentUpdateDatePresent() {
        return this.contentUpdateDatePresent;
    }

    public boolean isCreationeDatePresent() {
        return this.creationDatePresent;
    }

    public boolean isAttachmentDatePresent() {
        return this.attachmentDatePresent;
    }
}

