/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xwiki.tool.xar.AbstractXARMojo;
import org.xwiki.tool.xar.XWikiDocument;

public class XARMojo
extends AbstractXARMojo {
    private boolean includeDependencies;

    public void execute() throws MojoExecutionException {
        if (this.project.getResources().size() < 1) {
            this.getLog().warn((CharSequence)"No XAR created as no resources were found");
            return;
        }
        try {
            this.performArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating XAR file", e);
        }
    }

    private void performArchive() throws Exception {
        File xarFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + ".xar");
        File sourceDir = new File(this.project.getBuild().getOutputDirectory());
        File resourcesDir = this.getResourcesDirectory();
        if (sourceDir.listFiles() == null) {
            throw new Exception(String.format("No XAR XML files found in [%s]. Has the Maven Resource plugin be called?", sourceDir));
        }
        ZipArchiver archiver = new ZipArchiver();
        archiver.setEncoding(this.encoding);
        archiver.setDestFile(xarFile);
        archiver.setIncludeEmptyDirs(false);
        archiver.setCompress(true);
        if (this.includeDependencies) {
            this.unpackDependentXARs();
        }
        FilenameFilter packageXmlFiler = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("package.xml");
            }
        };
        if (!resourcesDir.exists() || resourcesDir.list(packageXmlFiler).length == 0) {
            this.addFilesToArchive(archiver, sourceDir);
        } else {
            File packageXml = new File(resourcesDir, "package.xml");
            this.addFilesToArchive(archiver, sourceDir, packageXml);
        }
        archiver.createArchive();
        this.project.getArtifact().setFile(xarFile);
    }

    private void unpackDependentXARs() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (artifact.isOptional() || !"xar".equals(artifact.getType())) continue;
                this.unpackXARToOutputDirectory(artifact);
            }
        }
    }

    private void generatePackageXml(File packageFile, Collection<ArchiveEntry> files) throws Exception {
        this.getLog().info((CharSequence)String.format("Generating package.xml descriptor at [%s]", packageFile.getPath()));
        OutputFormat outputFormat = new OutputFormat("", true);
        outputFormat.setEncoding(this.encoding);
        FileOutputStream out = new FileOutputStream(packageFile);
        XMLWriter writer = new XMLWriter((OutputStream)out, outputFormat);
        writer.write(this.toXML(files));
        writer.close();
        ((OutputStream)out).close();
    }

    private Document toXML(Collection<ArchiveEntry> files) {
        DOMDocument doc = new DOMDocument();
        DOMElement packageElement = new DOMElement("package");
        doc.setRootElement((Element)packageElement);
        DOMElement infoElement = new DOMElement("infos");
        packageElement.add((Element)infoElement);
        this.addInfoElements((Element)infoElement);
        DOMElement filesElement = new DOMElement("files");
        packageElement.add((Element)filesElement);
        this.addFileElements(files, (Element)filesElement);
        return doc;
    }

    private void addInfoElements(Element infoElement) {
        DOMElement el = new DOMElement("name");
        el.addText(this.project.getName());
        infoElement.add((Element)el);
        el = new DOMElement("description");
        String description = this.project.getDescription();
        if (description == null) {
            el.addText("");
        } else {
            el.addText(description);
        }
        infoElement.add((Element)el);
        el = new DOMElement("licence");
        el.addText("");
        infoElement.add((Element)el);
        el = new DOMElement("author");
        el.addText("XWiki.Admin");
        infoElement.add((Element)el);
        el = new DOMElement("extensionId");
        el.addText(this.project.getGroupId() + ':' + this.project.getArtifactId());
        infoElement.add((Element)el);
        el = new DOMElement("version");
        el.addText(this.project.getVersion());
        infoElement.add((Element)el);
        el = new DOMElement("backupPack");
        el.addText("true");
        infoElement.add((Element)el);
    }

    private void addFileElements(Collection<ArchiveEntry> files, Element filesElement) {
        for (ArchiveEntry entry : files) {
            XWikiDocument xdoc;
            if (entry.getName().indexOf("META-INF") != -1 || (xdoc = this.getDocFromXML(entry.getFile())) == null) continue;
            String fullName = xdoc.getFullName();
            DOMElement element = new DOMElement("file");
            element.setText(fullName);
            element.addAttribute("language", xdoc.getLanguage());
            element.addAttribute("defaultAction", "0");
            filesElement.add((Element)element);
        }
    }

    protected static Collection<String> getDocumentNamesFromXML(File file) throws Exception {
        LinkedList<String> result = new LinkedList<String>();
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        Element filesElement = domdoc.getRootElement().element("files");
        if (filesElement == null) {
            throw new Exception("The supplied document contains no document list ");
        }
        List elements = filesElement.elements("file");
        for (Object item : elements) {
            if (!(item instanceof Element)) continue;
            Element currentElement = (Element)item;
            String documentName = currentElement.getText();
            result.add(documentName);
        }
        return result;
    }

    private void addFilesToArchive(ZipArchiver archiver, File sourceDir) throws Exception {
        File generatedPackageFile = new File(sourceDir, "package.xml");
        if (generatedPackageFile.exists()) {
            generatedPackageFile.delete();
        }
        archiver.addDirectory(sourceDir, this.getIncludes(), this.getExcludes());
        this.generatePackageXml(generatedPackageFile, archiver.getFiles().values());
        archiver.addFile(generatedPackageFile, "package.xml");
    }

    private void addFilesToArchive(ZipArchiver archiver, File sourceDir, File packageXml) throws Exception {
        Collection<String> documentNames;
        this.getLog().info((CharSequence)String.format("Using the existing package.xml descriptor at [%s]", packageXml.getPath()));
        try {
            documentNames = XARMojo.getDocumentNamesFromXML(packageXml);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("The existing [%s] is invalid.", "package.xml"));
            throw e;
        }
        LinkedList<File> fileQueue = new LinkedList<File>();
        XARMojo.addContentsToQueue(fileQueue, sourceDir);
        while (!fileQueue.isEmpty() && !documentNames.isEmpty()) {
            File currentFile = (File)fileQueue.poll();
            if (currentFile.isDirectory()) {
                XARMojo.addContentsToQueue(fileQueue, currentFile);
                continue;
            }
            String documentName = XWikiDocument.getFullName(currentFile);
            if (!documentNames.contains(documentName)) continue;
            String archivedFilePath = currentFile.getAbsolutePath().substring((sourceDir.getAbsolutePath() + File.separator).length());
            archivedFilePath.replace(File.separatorChar, '/');
            archiver.addFile(currentFile, archivedFilePath);
            documentNames.remove(documentName);
        }
        if (!documentNames.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("The following documents could not be found: ");
            for (String name : documentNames) {
                errorMessage.append(name);
                errorMessage.append(" ");
            }
            throw new Exception(errorMessage.toString());
        }
        archiver.addFile(packageXml, "package.xml");
    }

    private static void addContentsToQueue(Queue<File> fileQueue, File sourceDir) {
        for (File currentFile : sourceDir.listFiles()) {
            fileQueue.add(currentFile);
        }
    }
}

