/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.tool.xar.AbstractXARMojo;

public abstract class AbstractVerifyMojo
extends AbstractXARMojo {
    protected static final String AUTHOR = "xwiki:XWiki.Admin";
    protected static final String VERSION = "1.1";
    private static final String EXTENSION = ".xml";
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("(.*)\\..*\\.xml");
    protected boolean force;
    protected String defaultLanguage;

    protected Collection<File> getXARXMLFiles() {
        File resourcesDir = this.getResourcesDirectory();
        Collection<File> files = Collections.emptyList();
        if (resourcesDir.exists()) {
            files = FileUtils.listFiles((File)resourcesDir, (IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)EXTENSION), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"package.xml"))}), (IOFileFilter)TrueFileFilter.INSTANCE);
        }
        return files;
    }

    protected String guessDefaultLanguage(File file, Collection<File> xwikiXmlFiles) {
        String language = "";
        Matcher matcher = TRANSLATION_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            language = this.defaultLanguage;
        } else {
            String prefix = StringUtils.substringBeforeLast((String)file.getName(), (String)EXTENSION);
            Pattern translationPattern = Pattern.compile(String.format("%s\\..*\\.xml", Pattern.quote(prefix)));
            for (File xwikiXmlFile : xwikiXmlFiles) {
                Matcher translationMatcher = translationPattern.matcher(xwikiXmlFile.getName());
                if (!translationMatcher.matches()) continue;
                language = this.defaultLanguage;
                break;
            }
        }
        return language;
    }
}

