/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultVelocityEngine
extends AbstractLogEnabled
implements VelocityEngine,
LogChute {
    @Requirement
    private ComponentManager componentManager;
    @Requirement
    private VelocityConfiguration velocityConfiguration;
    private org.apache.velocity.app.VelocityEngine engine;
    private RuntimeServices rsvc;
    private final Map<String, Integer> namespaceUsageCount = new HashMap<String, Integer>();

    public void initialize(Properties overridingProperties) throws XWikiVelocityException {
        org.apache.velocity.app.VelocityEngine velocityEngine = new org.apache.velocity.app.VelocityEngine();
        velocityEngine.setApplicationAttribute((Object)ComponentManager.class.getName(), (Object)this.componentManager);
        this.initializeProperties(velocityEngine, this.velocityConfiguration.getProperties(), overridingProperties);
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Cannot start the Velocity engine", e);
        }
        this.engine = velocityEngine;
    }

    private void initializeProperties(org.apache.velocity.app.VelocityEngine velocityEngine, Properties configurationProperties, Properties overridingProperties) {
        String value;
        String key;
        Enumeration<?> e;
        velocityEngine.setProperty("velocimacro.library", (Object)"");
        velocityEngine.setProperty("runtime.log.logsystem", (Object)this);
        if (configurationProperties != null) {
            e = configurationProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                if (overridingProperties.containsKey(key)) continue;
                value = configurationProperties.getProperty(key);
                velocityEngine.setProperty(key, (Object)value);
                this.getLogger().debug("Setting property [" + key + "] = [" + value + "]");
            }
        }
        if (overridingProperties != null) {
            e = overridingProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                value = overridingProperties.getProperty(key);
                velocityEngine.setProperty(key, (Object)value);
                this.getLogger().debug("Overriding property [" + key + "] = [" + value + "]");
            }
        }
    }

    public boolean evaluate(Context context, Writer out, String templateName, String source) throws XWikiVelocityException {
        return this.evaluate(context, out, templateName, new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Context context, Writer out, String templateName, Reader source) throws XWikiVelocityException {
        if (this.engine == null) {
            throw new XWikiVelocityException("This Velocity Engine has not yet been initialized.  You must call its initialize() method before you can use it.");
        }
        try {
            SimpleNode nodeTree = null;
            nodeTree = this.rsvc.parse(source, templateName, false);
            if (nodeTree != null) {
                InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
                ica.pushCurrentTemplateName(templateName);
                try {
                    nodeTree.init((InternalContextAdapter)ica, (Object)this.rsvc);
                    nodeTree.render((InternalContextAdapter)ica, out);
                }
                finally {
                    ica.popCurrentTemplateName();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Failed to evaluate content with id [" + templateName + "]", e);
        }
    }

    public void clearMacroNamespace(String templateName) {
        this.rsvc.dumpVMNamespace(templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startedUsingMacroNamespace(String namespace) {
        Map<String, Integer> map = this.namespaceUsageCount;
        synchronized (map) {
            Integer count = this.namespaceUsageCount.get(namespace);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.namespaceUsageCount.put(namespace, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stoppedUsingMacroNamespace(String namespace) {
        Map<String, Integer> map = this.namespaceUsageCount;
        synchronized (map) {
            Integer count = this.namespaceUsageCount.get(namespace);
            if (count == null) {
                this.log(2, "Wrong usage count for namespace [" + namespace + "]");
                return;
            }
            if ((count = Integer.valueOf(count - 1)) <= 0) {
                this.namespaceUsageCount.remove(namespace);
                this.clearMacroNamespace(namespace);
            } else {
                this.namespaceUsageCount.put(namespace, count);
            }
        }
    }

    public void init(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message);
                break;
            }
            case 1: {
                this.getLogger().debug(message);
                break;
            }
            case 0: {
                this.getLogger().debug(message);
                break;
            }
            case 3: {
                this.getLogger().error(message);
                break;
            }
            default: {
                this.getLogger().debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable throwable) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message, throwable);
                break;
            }
            case 1: {
                this.getLogger().debug(message, throwable);
                break;
            }
            case 0: {
                this.getLogger().debug(message, throwable);
                break;
            }
            case 3: {
                this.getLogger().error(message, throwable);
                break;
            }
            default: {
                this.getLogger().debug(message, throwable);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        boolean isEnabled;
        switch (level) {
            case 2: {
                isEnabled = this.getLogger().isWarnEnabled();
                break;
            }
            case 1: {
                isEnabled = this.getLogger().isDebugEnabled();
                break;
            }
            case 0: {
                isEnabled = this.getLogger().isDebugEnabled();
                break;
            }
            case 3: {
                isEnabled = this.getLogger().isErrorEnabled();
                break;
            }
            default: {
                isEnabled = this.getLogger().isDebugEnabled();
            }
        }
        return isEnabled;
    }
}

