/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal.util;

import java.util.HashSet;
import java.util.Set;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.logging.Logger;
import org.xwiki.velocity.internal.util.InvalidVelocityException;
import org.xwiki.velocity.internal.util.VelocityBlock;
import org.xwiki.velocity.internal.util.VelocityParserContext;

public class VelocityParser
extends AbstractLogEnabled {
    public static final Set<String> VELOCITYDIRECTIVE_BEGIN = new HashSet<String>();
    public static final Set<String> VELOCITYDIRECTIVE_END = new HashSet<String>();
    public static final Set<String> VELOCITYDIRECTIVE_PARAM = new HashSet<String>();
    public static final Set<String> VELOCITYDIRECTIVE_NOPARAM = new HashSet<String>();
    public static final Set<String> VELOCITYDIRECTIVE_ALL = new HashSet<String>();

    public VelocityParser(Logger logger) {
        this.enableLogging(logger);
    }

    public int getKeyWord(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i = currentIndex;
        if (i + 1 >= array.length) {
            throw new InvalidVelocityException();
        }
        if (array[i + 1] == '#') {
            i = this.getSimpleComment(array, currentIndex, velocityBlock, context);
        } else if (array[i + 1] == '*') {
            i = this.getMultilinesComment(array, currentIndex, velocityBlock, context);
        } else if (array[i + 1] == '{' || Character.isLetter(array[i + 1])) {
            i = this.getDirective(array, currentIndex, velocityBlock, context);
        } else {
            throw new InvalidVelocityException();
        }
        return i;
    }

    public int getDirective(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i = currentIndex + 1;
        StringBuffer directiveNameBuffer = new StringBuffer();
        String directiveName = directiveNameBuffer.toString();
        if (!VELOCITYDIRECTIVE_NOPARAM.contains(directiveName)) {
            for (i = this.getDirectiveName(array, i, directiveNameBuffer, null, context); i < array.length && array[i] == ' '; ++i) {
            }
            if (i < array.length && array[i] == '(') {
                i = this.getMethodParameters(array, i, null, context);
            } else {
                throw new InvalidVelocityException();
            }
        }
        if (VELOCITYDIRECTIVE_ALL.contains(directiveName)) {
            if (VELOCITYDIRECTIVE_BEGIN.contains(directiveName)) {
                context.pushVelocityElement(new VelocityBlock(directiveName, VelocityBlock.VelocityType.DIRECTIVE));
            } else if (VELOCITYDIRECTIVE_END.contains(directiveName)) {
                context.popVelocityElement();
            }
            i = this.getDirectiveEndOfLine(array, i, null, context);
            context.setType(VelocityBlock.VelocityType.DIRECTIVE);
        } else {
            context.setType(VelocityBlock.VelocityType.MACRO);
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getVelocityIdentifier(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i;
        if (!Character.isLetter(array[currentIndex])) {
            throw new InvalidVelocityException();
        }
        for (i = currentIndex + 1; i < array.length && array[i] != '}' && this.isValidVelocityIdentifierChar(array[i]); ++i) {
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public boolean isValidVelocityIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-';
    }

    public int getDirectiveName(char[] array, int currentIndex, StringBuffer directiveName, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i = currentIndex;
        if (i == array.length) {
            throw new InvalidVelocityException();
        }
        if (array[i] == '{') {
            ++i;
        }
        if ((i = this.getVelocityIdentifier(array, i, directiveName, context)) < array.length && array[i] == '}') {
            ++i;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getDirectiveEndOfLine(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex; i < array.length; ++i) {
            if (array[i] == '\n') {
                ++i;
                break;
            }
            if (Character.isWhitespace(array[i])) continue;
            return currentIndex;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getSimpleComment(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex + 2; i < array.length && array[i - 1] != '\n'; ++i) {
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        context.setType(VelocityBlock.VelocityType.COMMENT);
        return i;
    }

    public int getMultilinesComment(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex + 2; i < array.length && (array[i - 1] != '#' || array[i - 2] != '*'); ++i) {
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        context.setType(VelocityBlock.VelocityType.COMMENT);
        return i;
    }

    public int getVar(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        return this.getVar(array, currentIndex, null, velocityBlock, context);
    }

    public int getVar(char[] array, int currentIndex, StringBuffer varName, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        if (this.isVarEscaped(array, currentIndex)) {
            throw new InvalidVelocityException();
        }
        int i = currentIndex + 1;
        if (i == array.length) {
            throw new InvalidVelocityException();
        }
        if (array[i] == '!') {
            ++i;
        }
        if (i == array.length) {
            throw new InvalidVelocityException();
        }
        boolean fullSyntax = false;
        if (array[i] == '{') {
            ++i;
            fullSyntax = true;
        }
        if (i == array.length) {
            throw new InvalidVelocityException();
        }
        i = this.getVelocityIdentifier(array, i, varName, context);
        i = this.followVar(array, i, fullSyntax, context);
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        context.setType(VelocityBlock.VelocityType.VAR);
        return i;
    }

    private boolean isVarEscaped(char[] array, int currentIndex) {
        int i;
        for (i = currentIndex - 1; i >= 0 && array[i] == '\\'; --i) {
        }
        return (currentIndex - i) % 2 == 0;
    }

    private int followVar(char[] array, int currentIndex, boolean fullSyntax, VelocityParserContext context) {
        int i = currentIndex;
        while (i < array.length) {
            if (fullSyntax && array[i] == '}') {
                ++i;
                break;
            }
            if (array[i] == '.') {
                try {
                    i = this.getMethodOrProperty(array, i, null, context);
                    continue;
                }
                catch (InvalidVelocityException e) {
                    this.getLogger().debug("Not a valid method at char [" + i + "]", (Throwable)e);
                    break;
                }
            }
            if (array[i] != '[') break;
            i = this.getTableElement(array, i, null, context);
            break;
        }
        return i;
    }

    public int getMethodOrProperty(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i = currentIndex + 1;
        if (Character.isLetter(array[i])) {
            while (i < array.length) {
                if (array[i] == '(') {
                    i = this.getMethodParameters(array, i, null, context);
                } else if (Character.isLetterOrDigit(array[i])) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            throw new InvalidVelocityException();
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getTableElement(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        return this.getParameters(array, currentIndex, velocityBlock, ']', context);
    }

    public int getMethodParameters(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        return this.getParameters(array, currentIndex, velocityBlock, ')', context);
    }

    public int getParameters(char[] array, int currentIndex, StringBuffer velocityBlock, char endingChar, VelocityParserContext context) {
        char beginChar = array[currentIndex];
        int i = currentIndex + 1;
        int depth = 1;
        while (i < array.length) {
            if (array[i] == endingChar) {
                if (--depth == 0) {
                    ++i;
                    break;
                }
            } else if (array[i] == beginChar) {
                ++depth;
            } else if (array[i] == '\"' || array[i] == '\'') {
                i = this.getEscape(array, i, null, context);
                continue;
            }
            ++i;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getEscape(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        char escapeChar = array[currentIndex];
        int i = currentIndex + 1;
        boolean escaped = false;
        while (i < array.length) {
            if (!escaped) {
                if (array[i] == '\\') {
                    escaped = true;
                } else if (array[i] == '$') {
                    try {
                        i = this.getVar(array, i, null, context);
                        continue;
                    }
                    catch (InvalidVelocityException e) {
                        this.getLogger().debug("Not a valid variable at char [" + i + "]", (Throwable)e);
                    }
                } else if (array[i] == escapeChar) {
                    ++i;
                    break;
                }
            } else {
                escaped = false;
            }
            ++i;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getWhiteSpaces(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex; i < array.length && Character.isWhitespace(array[i]); ++i) {
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getSpaces(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex; i < array.length && Character.isWhitespace(array[i]); ++i) {
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getMacroParametersSeparator(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i = currentIndex;
        if (array[i = this.getWhiteSpaces(array, i, null, context)] == ',') {
            ++i;
        }
        i = this.getWhiteSpaces(array, i, null, context);
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    public int getMacroParameter(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        int i;
        for (i = currentIndex; i < array.length; ++i) {
            if (array[i] == '$') {
                try {
                    i = this.getVar(array, i, null, context);
                    break;
                }
                catch (InvalidVelocityException e) {
                    this.getLogger().debug("Not a valid velocity variable at char [" + i + "]", (Throwable)e);
                    continue;
                }
            }
            if (array[i] == '\"' || array[i] == '\'') {
                i = this.getEscape(array, i, null, context);
                break;
            }
            if (Character.isWhitespace(array[i]) || array[i] == ',' || array[i] == ')') break;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    static {
        VELOCITYDIRECTIVE_BEGIN.add("if");
        VELOCITYDIRECTIVE_BEGIN.add("foreach");
        VELOCITYDIRECTIVE_BEGIN.add("literal");
        VELOCITYDIRECTIVE_BEGIN.add("macro");
        VELOCITYDIRECTIVE_BEGIN.add("define");
        VELOCITYDIRECTIVE_END.add("end");
        VELOCITYDIRECTIVE_PARAM.addAll(VELOCITYDIRECTIVE_BEGIN);
        VELOCITYDIRECTIVE_PARAM.add("set");
        VELOCITYDIRECTIVE_PARAM.add("elseif");
        VELOCITYDIRECTIVE_PARAM.add("evaluate");
        VELOCITYDIRECTIVE_PARAM.add("include");
        VELOCITYDIRECTIVE_NOPARAM.addAll(VELOCITYDIRECTIVE_END);
        VELOCITYDIRECTIVE_NOPARAM.add("else");
        VELOCITYDIRECTIVE_NOPARAM.add("break");
        VELOCITYDIRECTIVE_NOPARAM.add("stop");
        VELOCITYDIRECTIVE_ALL.addAll(VELOCITYDIRECTIVE_PARAM);
        VELOCITYDIRECTIVE_ALL.addAll(VELOCITYDIRECTIVE_NOPARAM);
    }
}

