/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.log.AbstractSLF4JLogChute;
import org.xwiki.velocity.introspection.TryCatchDirective;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultVelocityEngine
extends AbstractSLF4JLogChute
implements VelocityEngine {
    private static final String TEMPLATE_SCOPE_NAME = "template";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private VelocityConfiguration velocityConfiguration;
    @Inject
    private VelocityContextFactory velocityContextFactory;
    @Inject
    private Logger logger;
    private org.apache.velocity.app.VelocityEngine engine;
    private RuntimeServices rsvc;
    private final Map<String, Integer> namespaceUsageCount = new ConcurrentHashMap<String, Integer>();

    @Override
    public void initialize(Properties overridingProperties) throws XWikiVelocityException {
        org.apache.velocity.app.VelocityEngine velocityEngine = new org.apache.velocity.app.VelocityEngine();
        velocityEngine.setApplicationAttribute((Object)ComponentManager.class.getName(), (Object)this.componentManager);
        this.initializeProperties(velocityEngine, this.velocityConfiguration.getProperties(), overridingProperties);
        velocityEngine.loadDirective(TryCatchDirective.class.getName());
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Cannot start the Velocity engine", e);
        }
        this.engine = velocityEngine;
    }

    private void initializeProperties(org.apache.velocity.app.VelocityEngine velocityEngine, Properties configurationProperties, Properties overridingProperties) {
        String value;
        String key;
        Enumeration<?> e;
        velocityEngine.setProperty("velocimacro.library", (Object)"");
        velocityEngine.setProperty("runtime.log.logsystem", (Object)this);
        if (configurationProperties != null) {
            e = configurationProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                if (overridingProperties.containsKey(key)) continue;
                value = configurationProperties.getProperty(key);
                velocityEngine.setProperty(key, (Object)value);
                this.logger.debug("Setting property [{}] = [{}]", (Object)key, (Object)value);
            }
        }
        if (overridingProperties != null) {
            e = overridingProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                value = overridingProperties.getProperty(key);
                velocityEngine.setProperty(key, (Object)value);
                this.logger.debug("Overriding property [{}] = [{}]", (Object)key, (Object)value);
            }
        }
    }

    private void restoreTemplateScope(InternalContextAdapterImpl ica, Scope currentTemplateScope) {
        if (currentTemplateScope.getParent() != null) {
            ica.put(TEMPLATE_SCOPE_NAME, (Object)currentTemplateScope.getParent());
        } else if (currentTemplateScope.getReplaced() != null) {
            ica.put(TEMPLATE_SCOPE_NAME, currentTemplateScope.getReplaced());
        } else {
            ica.remove((Object)TEMPLATE_SCOPE_NAME);
        }
    }

    private String toThreadSafeNamespace(String namespace) {
        return StringUtils.isNotEmpty((CharSequence)namespace) ? Thread.currentThread().getId() + ":" + namespace : namespace;
    }

    @Override
    public boolean evaluate(Context context, Writer out, String templateName, String source) throws XWikiVelocityException {
        return this.evaluate(context, out, templateName, new StringReader(source));
    }

    @Override
    public boolean evaluate(Context context, Writer out, String templateName, Reader source) throws XWikiVelocityException {
        if (this.engine == null) {
            throw new XWikiVelocityException("This Velocity Engine has not yet been initialized.  You must call its initialize() method before you can use it.");
        }
        String namespace = this.toThreadSafeNamespace(templateName);
        try {
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                this.startedUsingMacroNamespaceInternal(namespace);
            }
            boolean bl = this.evaluateInternal(context, out, namespace, source);
            return bl;
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Failed to evaluate content with id [" + templateName + "]", e);
        }
        finally {
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                this.stoppedUsingMacroNamespaceInternal(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateInternal(Context context, Writer out, String namespace, Reader source) throws Exception {
        SimpleNode nodeTree = this.rsvc.parse(source, namespace, false);
        if (nodeTree != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl((Context)(context != null ? context : this.velocityContextFactory.createContext()));
            ica.pushCurrentTemplateName(namespace);
            boolean provideTemplateScope = this.rsvc.getBoolean("template.provide.scope.control", true);
            Object templateScopeMarker = new Object();
            Scope templateScope = null;
            if (provideTemplateScope) {
                Object previous = ica.get(TEMPLATE_SCOPE_NAME);
                templateScope = new Scope(templateScopeMarker, previous);
                templateScope.put((Object)"templateName", (Object)namespace);
                ica.put(TEMPLATE_SCOPE_NAME, (Object)templateScope);
            }
            try {
                nodeTree.init((InternalContextAdapter)ica, (Object)this.rsvc);
                nodeTree.render((InternalContextAdapter)ica, out);
            }
            catch (StopCommand stop) {
                if (!stop.isFor(templateScopeMarker) && ica.getTemplateNameStack().length > 1) {
                    throw stop;
                }
            }
            finally {
                ica.popCurrentTemplateName();
                if (provideTemplateScope) {
                    this.restoreTemplateScope(ica, templateScope);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearMacroNamespace(String templateName) {
        this.rsvc.dumpVMNamespace(this.toThreadSafeNamespace(templateName));
    }

    @Override
    public void startedUsingMacroNamespace(String namespace) {
        this.startedUsingMacroNamespaceInternal(this.toThreadSafeNamespace(namespace));
    }

    private void startedUsingMacroNamespaceInternal(String namespace) {
        Integer count = this.namespaceUsageCount.get(namespace);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.namespaceUsageCount.put(namespace, count);
    }

    @Override
    public void stoppedUsingMacroNamespace(String namespace) {
        this.stoppedUsingMacroNamespaceInternal(this.toThreadSafeNamespace(namespace));
    }

    private void stoppedUsingMacroNamespaceInternal(String namespace) {
        Integer count = this.namespaceUsageCount.get(namespace);
        if (count == null) {
            this.logger.warn("Wrong usage count for namespace [{}]", (Object)namespace);
            return;
        }
        if ((count = Integer.valueOf(count - 1)) <= 0) {
            this.namespaceUsageCount.remove(namespace);
            this.rsvc.dumpVMNamespace(namespace);
        } else {
            this.namespaceUsageCount.put(namespace, count);
        }
    }

    public void init(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

