/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

public class TryCatchDirective
extends Directive {
    private static final String EXCEPTION_KEY_NAME = "exception";

    public String getName() {
        return "try";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        boolean result = true;
        String exceptionVariableName = EXCEPTION_KEY_NAME;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                exceptionVariableName = (String)node.jjtGetChild(i).value(context);
                continue;
            }
            try {
                context.remove((Object)exceptionVariableName);
                result = node.jjtGetChild(i).render(context, writer);
            }
            catch (Exception e) {
                context.put(exceptionVariableName, (Object)e);
                result = true;
            }
            break;
        }
        return result;
    }
}

