/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule m = new SimpleModule("org.json.* serializer", new Version(1, 0, 0, "", "org.json", "json"));
            m.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
            m.addSerializer(JSONArray.class, (JsonSerializer)new JSONArraySerializer());
            mapper.registerModule((Module)m);
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to serialize object to JSON", (Throwable)e);
            return null;
        }
    }

    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }

    class JSONArraySerializer
    extends JsonSerializer<JSONArray> {
        JSONArraySerializer() {
        }

        public void serialize(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeRawValue(value.toString());
        }
    }

    class JSONObjectSerializer
    extends JsonSerializer<JSONObject> {
        JSONObjectSerializer() {
        }

        public void serialize(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeRawValue(value.toString());
        }
    }
}

