/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagTransformation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;
import org.xwiki.xml.internal.html.DefaultHTMLCleanerConfiguration;
import org.xwiki.xml.internal.html.XWikiDOMSerializer;

public class DefaultHTMLCleaner
implements HTMLCleaner,
Initializable {
    private static final String QUALIFIED_NAME_HTML = "html";
    @Requirement(value="list")
    private HTMLFilter listFilter;
    @Requirement(value="font")
    private HTMLFilter fontFilter;
    @Requirement(value="body")
    private HTMLFilter bodyFilter;

    public void initialize() throws InitializationException {
        this.clean(new StringReader(""));
    }

    public Document clean(Reader originalHtmlContent) {
        return this.clean(originalHtmlContent, this.getDefaultConfiguration());
    }

    public Document clean(Reader originalHtmlContent, HTMLCleanerConfiguration configuration) {
        TagNode cleanedNode;
        Document result = null;
        CleanerProperties cleanerProperties = this.getDefaultCleanerProperties(configuration);
        HtmlCleaner cleaner = new HtmlCleaner(cleanerProperties);
        cleaner.setTransformations(this.getDefaultCleanerTransformations());
        try {
            cleanedNode = cleaner.clean(originalHtmlContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Unhandled error when cleaning HTML", e);
        }
        this.fixCleanedNodeBug(cleanedNode);
        try {
            Document tempDoc = new XWikiDOMSerializer(cleanerProperties, false).createDOM(cleanedNode);
            DOMImplementation domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(QUALIFIED_NAME_HTML, "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            result = domImpl.createDocument(null, QUALIFIED_NAME_HTML, docType);
            result.replaceChild(result.adoptNode(tempDoc.getDocumentElement()), result.getDocumentElement());
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error while serializing TagNode into w3c dom.", ex);
        }
        for (HTMLFilter filter : configuration.getFilters()) {
            filter.filter(result, configuration.getParameters());
        }
        return result;
    }

    public HTMLCleanerConfiguration getDefaultConfiguration() {
        DefaultHTMLCleanerConfiguration configuration = new DefaultHTMLCleanerConfiguration();
        configuration.setFilters(Arrays.asList(this.bodyFilter, this.listFilter, this.fontFilter));
        return configuration;
    }

    private CleanerProperties getDefaultCleanerProperties(HTMLCleanerConfiguration configuration) {
        CleanerProperties defaultProperties = new CleanerProperties();
        defaultProperties.setOmitUnknownTags(true);
        defaultProperties.setNamespacesAware(true);
        defaultProperties.setUseEmptyElementTags(false);
        defaultProperties.setUseCdataForScriptAndStyle(true);
        String param = configuration.getParameters().get("namespacesAware");
        boolean namespacesAware = param != null ? Boolean.parseBoolean(param) : defaultProperties.isNamespacesAware();
        defaultProperties.setNamespacesAware(namespacesAware);
        return defaultProperties;
    }

    private CleanerTransformations getDefaultCleanerTransformations() {
        CleanerTransformations defaultTransformations = new CleanerTransformations();
        TagTransformation tt = new TagTransformation("b", "strong", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("i", "em", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("u", "ins", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("s", "del", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("strike", "del", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("center", "p", false);
        tt.addAttributeTransformation("style", "text-align:center");
        defaultTransformations.addTransformation(tt);
        return defaultTransformations;
    }

    private void fixCleanedNodeBug(TagNode cleanedNode) {
        Object firstBodyChild;
        TagNode body = cleanedNode.getElementsByName("body", false)[0];
        if (body.getChildren().size() > 0 && (firstBodyChild = body.getChildren().get(0)) instanceof ContentToken && ((ContentToken)firstBodyChild).getContent().startsWith("<?xml")) {
            body.removeChild(firstBodyChild);
        }
    }
}

