/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractHandler
extends DefaultHandler {
    private int lowerBound;
    private int upperBound;
    private int counter;
    private Stack<XMLTag> openedTags = new Stack();
    private StringBuilder result = new StringBuilder();
    private boolean finished;

    public ExtractHandler(int start, int length) throws SAXException {
        if (start < 0) {
            throw new SAXException("Start must be greater than or equal to 0");
        }
        if (length <= 0) {
            throw new SAXException("Length must be greater than 0");
        }
        this.lowerBound = start;
        this.upperBound = this.lowerBound + length;
    }

    public String getResult() {
        return this.result.toString();
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void openTag(String qName, Attributes atts) {
        this.result.append('<').append(qName);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.result.append(' ').append(atts.getQName(i)).append("=\"").append(atts.getValue(i)).append('\"');
        }
        this.result.append('>');
    }

    private void openTags() {
        for (XMLTag tag : this.openedTags) {
            this.openTag(tag.getQName(), tag.getAtts());
        }
    }

    private void closeTags() {
        while (!this.openedTags.isEmpty()) {
            this.closeTag(this.openedTags.pop().getQName());
        }
    }

    private void closeTag(String qName) {
        this.result.append("</").append(qName).append('>');
    }

    private boolean isExtracting() {
        return this.lowerBound <= this.counter && this.counter <= this.upperBound;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.counter = 0;
        this.openedTags.clear();
        this.result.setLength(0);
        this.finished = false;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.openedTags.push(new XMLTag(qName, atts));
        if (this.isExtracting()) {
            this.openTag(qName, atts);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int offset = this.lowerBound - this.counter;
        if (offset > 0) {
            if (offset > length) {
                this.counter += length;
                return;
            }
            this.counter = this.lowerBound;
            this.openTags();
            this.characters(ch, start + offset, length - offset);
            return;
        }
        int remainingLength = this.upperBound - this.counter;
        if (remainingLength <= length) {
            String content = new String(ch, start, remainingLength);
            int spaceIndex = remainingLength;
            if (length > remainingLength && ch[start + remainingLength] != ' ') {
                spaceIndex = content.lastIndexOf(32);
            }
            if (spaceIndex >= 0) {
                this.counter += spaceIndex;
                this.result.append(content.substring(0, spaceIndex));
            } else {
                this.counter = this.upperBound;
                this.result.append(content);
            }
            this.endDocument();
            throw new SAXException("Length limit reached");
        }
        this.counter += length;
        this.result.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.openedTags.pop();
        if (this.isExtracting()) {
            this.closeTag(qName);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.isExtracting()) {
            this.closeTags();
        }
        this.finished = true;
    }

    private static class XMLTag {
        private String qName;
        private Attributes atts;

        public XMLTag(String qName, Attributes atts) {
            this.qName = qName;
            this.atts = atts;
        }

        public String getQName() {
            return this.qName;
        }

        public Attributes getAtts() {
            return this.atts;
        }
    }
}

