/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Named(value="list")
@Singleton
public class ListFilter
extends AbstractHTMLFilter {
    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        for (Element list : this.filterDescendants(document.getDocumentElement(), new String[]{"ul", "ol"})) {
            this.filter(list);
        }
    }

    private void filter(Element list) {
        Node child = list.getFirstChild();
        Node previousListItem = null;
        while (child != null) {
            Node nextSibling = child.getNextSibling();
            if (this.isAllowedInsideList(child)) {
                if (child.getNodeName().equalsIgnoreCase("li")) {
                    previousListItem = child;
                }
            } else {
                if (previousListItem == null) {
                    previousListItem = list.getOwnerDocument().createElement("li");
                    list.insertBefore(previousListItem, child);
                    ((Element)previousListItem).setAttribute("style", "list-style-type: none");
                }
                previousListItem.appendChild(child);
            }
            child = nextSibling;
        }
    }

    private boolean isAllowedInsideList(Node node) {
        return !(node.getNodeType() == 1 && !node.getNodeName().equalsIgnoreCase("li") || node.getNodeType() == 3 && node.getNodeValue().trim().length() != 0);
    }
}

